/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;

public class ReqExclScorer
extends Scorer {
    private Scorer reqScorer;
    private Scorer exclScorer;
    private boolean firstTime = true;

    public ReqExclScorer(Scorer reqScorer, Scorer exclScorer) {
        super(null);
        this.reqScorer = reqScorer;
        this.exclScorer = exclScorer;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            if (!this.exclScorer.next()) {
                this.exclScorer = null;
            }
            this.firstTime = false;
        }
        if (this.reqScorer == null) {
            return false;
        }
        if (!this.reqScorer.next()) {
            this.reqScorer = null;
            return false;
        }
        if (this.exclScorer == null) {
            return true;
        }
        return this.toNonExcluded();
    }

    private boolean toNonExcluded() throws IOException {
        int exclDoc = this.exclScorer.doc();
        do {
            int reqDoc;
            if ((reqDoc = this.reqScorer.doc()) < exclDoc) {
                return true;
            }
            if (reqDoc <= exclDoc) continue;
            if (!this.exclScorer.skipTo(reqDoc)) {
                this.exclScorer = null;
                return true;
            }
            exclDoc = this.exclScorer.doc();
            if (exclDoc <= reqDoc) continue;
            return true;
        } while (this.reqScorer.next());
        this.reqScorer = null;
        return false;
    }

    public int doc() {
        return this.reqScorer.doc();
    }

    public float score() throws IOException {
        return this.reqScorer.score();
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.firstTime = false;
            if (!this.exclScorer.skipTo(target)) {
                this.exclScorer = null;
            }
        }
        if (this.reqScorer == null) {
            return false;
        }
        if (this.exclScorer == null) {
            return this.reqScorer.skipTo(target);
        }
        if (!this.reqScorer.skipTo(target)) {
            this.reqScorer = null;
            return false;
        }
        return this.toNonExcluded();
    }

    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        if (this.exclScorer.skipTo(doc) && this.exclScorer.doc() == doc) {
            res.setDescription("excluded");
        } else {
            res.setDescription("not excluded");
            res.addDetail(this.reqScorer.explain(doc));
        }
        return res;
    }
}

