/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Set;
import net.sf.snowball.ext.EnglishStemmer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

class EnglishPorterFilter
extends TokenFilter {
    private final Set protWords;
    private EnglishStemmer stemmer;

    public EnglishPorterFilter(TokenStream source, Set protWords) {
        super(source);
        this.protWords = protWords;
        this.stemmer = new EnglishStemmer();
    }

    public Token next() throws IOException {
        Token tok = this.input.next();
        if (tok == null) {
            return null;
        }
        String tokstr = tok.termText();
        if (this.protWords != null && this.protWords.contains(tokstr)) {
            return tok;
        }
        this.stemmer.setCurrent(tokstr);
        this.stemmer.stem();
        String newstr = this.stemmer.getCurrent();
        if (tokstr.equals(newstr)) {
            return tok;
        }
        Token newtok = new Token(newstr, tok.startOffset(), tok.endOffset(), tok.type());
        newtok.setPositionIncrement(tok.getPositionIncrement());
        return newtok;
    }
}

