/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.extension;

import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.dependencymanager.Service;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.container.EmptyResourceInjector;
import org.ow2.easybeans.osgi.binder.DefaultDependencyManager;

public class OSGiDependencyResourceInjector
extends EmptyResourceInjector {
    private DefaultDependencyManager manager = null;
    private final Map<Integer, Service> services = new Hashtable<Integer, Service>();
    private BundleContext defaultBundleContext;

    public void postEasyBeansInject(EasyBeansBean bean) {
        if (this.manager == null) {
            EZBContainer container = bean.getEasyBeansFactory().getContainer();
            BundleContext context = (BundleContext)container.getExtension(BundleContext.class);
            if (context == null) {
                context = this.defaultBundleContext;
            }
            this.manager = new DefaultDependencyManager(context);
        }
        Integer beanID = System.identityHashCode(bean);
        Service service = this.manager.createService(bean);
        this.services.put(beanID, service);
        this.manager.startTracking(service);
    }

    public void postEasyBeansDestroy(EasyBeansBean bean) {
        Integer beanID = System.identityHashCode(bean);
        Service service = this.services.get(beanID);
        this.manager.stopTracking(service);
    }

    public void setDefaultBundleContext(BundleContext defaultBundleContext) {
        this.defaultBundleContext = defaultBundleContext;
    }
}

