/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ejb2_1.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.ejb2_1.pool.EJBObjectFactory;
import org.ow2.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.cmi.ejb2_1.rpc.EJBObjectInvocationHandler;
import org.ow2.cmi.ejb2_1.spec.EJBHomeHandle;
import org.ow2.cmi.ejb2_1.spec.JMetaData;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class EJBHomeInvocationHandler
extends CMIInvocationHandler<EJBHome> {
    private static final long serialVersionUID = 2242340256790911121L;
    private static transient Log logger = LogFactory.getLog(EJBHomeInvocationHandler.class);
    private transient ClassLoader classLoader;
    private transient Class<? extends EJBObject> remoteClass;
    private transient EJBMetaData ejbMetaData = null;

    public EJBHomeInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass) {
        super(clusterViewManager, objectName, protocolName, false, homeClass);
        this.classLoader = classLoader;
        try {
            this.remoteClass = clusterViewManager.getRemoteClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            throw new EJBInvocationHandlerException("Cannot get the remote class for " + objectName, e);
        }
    }

    @Override
    protected String proxyToString(Object proxy) {
        return "EJBHomeProxy[" + super.proxyToString(proxy) + ", remoteClass:" + this.remoteClass.getName() + ", ejbMetada:" + this.ejbMetaData + "]";
    }

    @Override
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws EJBInvocationHandlerException, Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.equals("create")) {
                Object cmiProxy;
                EJBObjectInvocationHandler ejbObjectInvocationHandler = new EJBObjectInvocationHandler(this.classLoader, this.clusterViewManager, this.objectName, this.protocolName, this.itf, this.remoteClass, (EJBHome)proxy);
                Object object = cmiProxy = Proxy.newProxyInstance(this.classLoader, new Class[]{this.remoteClass, CMIProxy.class}, (InvocationHandler)ejbObjectInvocationHandler);
                return object;
            }
            if (methodName.equals("getEJBMetaData")) {
                if (this.ejbMetaData == null) {
                    boolean isSession = true;
                    boolean isStatelessSession = true;
                    Class<?> primaryKeyClass = null;
                    this.ejbMetaData = new JMetaData((EJBHome)proxy, this.itf, this.remoteClass, isSession, isStatelessSession, primaryKeyClass);
                }
                EJBMetaData isSession = this.ejbMetaData;
                return isSession;
            }
            if (methodName.equals("remove")) {
                Object isSession = null;
                return isSession;
            }
            try {
                throw new NoSuchMethodException(method.toString());
            }
            catch (Exception e) {
                if (e instanceof EJBException) {
                    throw e;
                }
                logger.error((Object)"Error when invoking {0}", new Object[]{method, e});
                throw new EJBInvocationHandlerException("Error when invoking " + method, e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkInitialized() throws EJBInvocationHandlerException {
        try {
            ClusterViewManager clusterViewManager = this.clusterViewManager;
            synchronized (clusterViewManager) {
                if (this.clusterViewManager.getPool(this.objectName) == null) {
                    logger.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBObject", new Object[]{this.objectName});
                    JPool pool = new JPool((PoolFactory)new EJBObjectFactory(this.clusterViewManager));
                    IPoolConfiguration poolConfiguration = this.clusterViewManager.getPoolConfiguration(this.objectName);
                    if (poolConfiguration != null) {
                        pool.setPoolConfiguration(poolConfiguration);
                    }
                    this.clusterViewManager.setPool(this.objectName, (Pool<CMIReferenceable<?>, CMIReference>)pool);
                }
            }
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (this.remoteClass == null) {
                this.remoteClass = this.clusterViewManager.getRemoteClass(this.objectName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot init the EJBHome proxy", new Object[]{e});
            throw new EJBInvocationHandlerException("Cannot init the EJBHome proxy", e);
        }
    }

    @Override
    protected String getHandleMethodName() {
        return "getHomeHandle";
    }

    @Override
    protected EJBHomeHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new EJBHomeHandle(this.objectName, this.itf.getName(), (EJBHome)cmiProxy);
        }
        return (EJBHomeHandle)this.cmiProxyHandle;
    }

    @Override
    protected CMIReferenceable<EJBHome> getCMIReferenceable(CMIReference cmiReference) throws Exception {
        return null;
    }

    @Override
    protected void onExceptionHook(String objectName, CMIReferenceable<EJBHome> cmiReferenceable) {
    }

    @Override
    protected void onFinallyHook(String objectName, CMIReferenceable<EJBHome> cmiReferenceable) {
    }
}

