/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.jndi.context;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.jndi.ClusteredObject;
import org.ow2.cmi.jndi.context.CMIContextException;
import org.ow2.cmi.jndi.context.CMINamingException;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.decision.DecisionManager;
import org.ow2.cmi.lb.policy.FirstAvailable;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.CMIProxyFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class CMIContext
implements Context {
    private static final Log LOGGER = LogFactory.getLog(CMIContext.class);
    private final Context localContext;
    private final String initialContextFactoryName;
    private final String protocol;
    private final boolean replicationEnabled;
    private final ServerId localRegistry;
    private final List<ServerRef> remoteRegistries;
    private final ClusterViewManager clusterViewManager;
    private IPolicy<ServerRef> defaultPolicy;
    private boolean notCloseable = false;
    private final String dummyRegistryName;

    public CMIContext(ClusterViewManager clusterViewManager, ServerId localRegistry, String initialContextFactoryName, String protocol, List<ServerRef> clusterViewProviderUrls) throws CMINamingException {
        this.initialContextFactoryName = initialContextFactoryName;
        this.clusterViewManager = clusterViewManager;
        this.localRegistry = localRegistry;
        this.protocol = protocol;
        this.replicationEnabled = clusterViewManager instanceof ServerClusterViewManager;
        this.dummyRegistryName = clusterViewManager.getConfig().getDummyRegistryName();
        this.remoteRegistries = clusterViewProviderUrls;
        try {
            this.setDefaultPolicy();
        }
        catch (CMIContextException e) {
            LOGGER.error((Object)"Cannot set the default LB policy", new Object[]{e});
            throw new CMINamingException("Cannot set the default LB policy", e);
        }
        this.localContext = localRegistry != null ? this.getRealContext(localRegistry.getProviderURL(), initialContextFactoryName) : null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        LOGGER.debug((Object)"addToEnvironment {0}", new Object[]{propName});
        if (this.localContext != null) {
            return this.localContext.addToEnvironment(propName, propVal);
        }
        LOGGER.warn((Object)"Cannot addToEnvironment because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        LOGGER.debug((Object)"bind {0}", new Object[]{name});
        if (this.localContext != null) {
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            this.localContext.bind(name, obj);
            if (this.replicationEnabled && this.clusterViewManager != null && this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE)) {
                try {
                    this.bindIntoCluster(name, obj);
                    LOGGER.debug((Object)"The object for name {0} has been added in the cluster.", new Object[]{name});
                }
                catch (CMIContextException e) {
                    LOGGER.error((Object)"Cannot add the object for name  {0} to the cluster", new Object[]{name});
                    CMINamingException ne = new CMINamingException("Cannot add the object for name {0} to the cluster" + name);
                    ne.setRootCause(e);
                    throw ne;
                }
            } else {
                LOGGER.debug((Object)"Replication is disabled", new Object[0]);
            }
        } else {
            LOGGER.warn((Object)"Cannot bind because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void close() throws NamingException {
        LOGGER.debug((Object)"close", new Object[0]);
        if (this.localContext != null) {
            if (!this.notCloseable) {
                this.localContext.close();
            }
        } else {
            LOGGER.warn((Object)"Cannot close because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.composeName(name, prefix);
        }
        LOGGER.warn((Object)"Cannot compose name because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.composeName(name, prefix);
        }
        LOGGER.warn((Object)"Cannot compose name because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.createSubcontext(name);
        }
        LOGGER.warn((Object)"Cannot create subcontext because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.createSubcontext(name);
        }
        LOGGER.warn((Object)"Cannot create subcontext because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (this.localContext != null) {
            this.localContext.destroySubcontext(name);
        } else {
            LOGGER.warn((Object)"Cannot destroy subcontext because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        if (this.localContext != null) {
            this.localContext.destroySubcontext(name);
        } else {
            LOGGER.warn((Object)"Cannot destroy subcontext because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (this.localContext != null) {
            return this.localContext.getEnvironment();
        }
        LOGGER.warn((Object)"Cannot getEnvironement because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.localContext != null) {
            return this.localContext.getNameInNamespace();
        }
        LOGGER.warn((Object)"Cannot getNameInNamespace because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.getNameParser(name);
        }
        LOGGER.warn((Object)"Cannot getNameParser because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.getNameParser(name);
        }
        LOGGER.warn((Object)"Cannot getNameParser because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Collection<LoadBalanceable> loadBalanceables;
        IPolicy<LoadBalanceable> lbPolicy;
        boolean localMode;
        if (this.localContext != null) {
            return this.localContext.list(name);
        }
        boolean bl = localMode = this.clusterViewManager == null || !this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE);
        if (!localMode) {
            try {
                lbPolicy = this.clusterViewManager.getPolicy(this.dummyRegistryName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get LB policy for object " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = this.clusterViewManager.getCMIReferences(this.dummyRegistryName, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get node list for " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultPolicy;
            loadBalanceables = this.remoteRegistries;
        }
        while (true) {
            ServerRef loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{loadBalanceables, lbPolicy, e});
                throw new CMINamingException("Cannot choose CMIReference in the list " + loadBalanceables + " with LB policy " + lbPolicy);
            }
            ServerRef serverRef = loadBalanceable.getServerRef();
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(name);
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
            }
            return namingEnumeration;
            catch (NamingException e) {
                block21: {
                    try {
                        LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                        DecisionManager<Void> decisionManager = lbPolicy.onLookupException(loadBalanceable, e);
                        if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                            LOGGER.debug((Object)"Throw: ", new Object[]{e});
                            throw e;
                        }
                        LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                        loadBalanceables.remove(loadBalanceable);
                        if (!loadBalanceables.isEmpty()) break block21;
                        LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                        throw e;
                    }
                    catch (Throwable throwable) {
                        try {
                            context.close();
                        }
                        catch (NamingException e2) {
                            LOGGER.debug((Object)"Unable to close the context", new Object[]{e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    context.close();
                }
                catch (NamingException e3) {
                    LOGGER.debug((Object)"Unable to close the context", new Object[]{e3});
                }
                continue;
            }
            break;
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Collection<LoadBalanceable> loadBalanceables;
        IPolicy<LoadBalanceable> lbPolicy;
        boolean localMode;
        if (this.localContext != null) {
            return this.localContext.listBindings(name);
        }
        boolean bl = localMode = this.clusterViewManager == null || !this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE);
        if (!localMode) {
            try {
                lbPolicy = this.clusterViewManager.getPolicy(this.dummyRegistryName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get LB policy for object " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = this.clusterViewManager.getCMIReferences(this.dummyRegistryName, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get node list for " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultPolicy;
            loadBalanceables = this.remoteRegistries;
        }
        while (true) {
            ServerRef loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{loadBalanceables, lbPolicy, e});
                throw new CMINamingException("Cannot choose CMIReference in the list " + loadBalanceables + " with LB policy " + lbPolicy);
            }
            ServerRef serverRef = loadBalanceable.getServerRef();
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(name);
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
            }
            return namingEnumeration;
            catch (NamingException e) {
                block21: {
                    try {
                        LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                        DecisionManager<Void> decisionManager = lbPolicy.onLookupException(loadBalanceable, e);
                        if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                            LOGGER.debug((Object)"Throw: ", new Object[]{e});
                            throw e;
                        }
                        LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                        loadBalanceables.remove(loadBalanceable);
                        if (!loadBalanceables.isEmpty()) break block21;
                        LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                        throw e;
                    }
                    catch (Throwable throwable) {
                        try {
                            context.close();
                        }
                        catch (NamingException e2) {
                            LOGGER.debug((Object)"Unable to close the context", new Object[]{e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    context.close();
                }
                catch (NamingException e3) {
                    LOGGER.debug((Object)"Unable to close the context", new Object[]{e3});
                }
                continue;
            }
            break;
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object lookup(String name) throws NamingException {
        Collection<LoadBalanceable> loadBalanceables;
        IPolicy<LoadBalanceable> lbPolicy;
        boolean localMode;
        boolean bl = localMode = this.clusterViewManager == null || !this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE);
        if (!localMode) {
            LOGGER.debug((Object)"lookup {0} using ClusterViewManager", new Object[]{name});
            if (this.clusterViewManager.isClustered(name)) {
                LOGGER.debug((Object)"{0} is clustered", new Object[]{name});
                try {
                    return this.findClusteredObject(name);
                }
                catch (CMIContextException e) {
                    LOGGER.warn((Object)("Clustered object not available: " + name), new Object[]{e});
                }
            }
        }
        if (this.localContext != null) {
            return this.localContext.lookup(name);
        }
        if (!localMode) {
            try {
                lbPolicy = this.clusterViewManager.getPolicy(this.dummyRegistryName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get LB policy for object " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = this.clusterViewManager.getCMIReferences(this.dummyRegistryName, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get node list for " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultPolicy;
            loadBalanceables = this.remoteRegistries;
        }
        while (true) {
            ServerRef loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{loadBalanceables, lbPolicy, e});
                throw new CMINamingException("Cannot choose CMIReference in the list " + loadBalanceables + " with LB policy " + lbPolicy, e);
            }
            ServerRef serverRef = loadBalanceable.getServerRef();
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            Object object = context.lookup(name);
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
            }
            return object;
            catch (NamingException e) {
                block25: {
                    try {
                        LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                        DecisionManager<Void> decisionManager = lbPolicy.onLookupException(loadBalanceable, e);
                        if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                            LOGGER.debug((Object)"Throw: ", new Object[]{e});
                            throw e;
                        }
                        LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                        loadBalanceables.remove(loadBalanceable);
                        if (!loadBalanceables.isEmpty()) break block25;
                        LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                        throw e;
                    }
                    catch (Throwable throwable) {
                        try {
                            context.close();
                        }
                        catch (NamingException e2) {
                            LOGGER.debug((Object)"Unable to close the context", new Object[]{e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    context.close();
                }
                catch (NamingException e3) {
                    LOGGER.debug((Object)"Unable to close the context", new Object[]{e3});
                }
                continue;
            }
            break;
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object lookupLink(String name) throws NamingException {
        Collection<LoadBalanceable> loadBalanceables;
        IPolicy<LoadBalanceable> lbPolicy;
        boolean localMode;
        boolean bl = localMode = this.clusterViewManager == null || !this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE);
        if (!localMode) {
            LOGGER.debug((Object)"lookup {0} using ClusterViewManager", new Object[]{name});
            if (this.clusterViewManager.isClustered(name)) {
                LOGGER.debug((Object)"{0} is clustered", new Object[]{name});
                try {
                    return this.findClusteredObject(name);
                }
                catch (CMIContextException e) {
                    LOGGER.warn((Object)("Clustered object not available: " + name), new Object[]{e});
                }
            }
        }
        if (this.localContext != null) {
            return this.localContext.lookupLink(name);
        }
        if (!localMode) {
            try {
                lbPolicy = this.clusterViewManager.getPolicy(this.dummyRegistryName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get LB policy for object " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"LB policy for dummy context: {0}", new Object[]{lbPolicy});
            try {
                loadBalanceables = this.clusterViewManager.getCMIReferences(this.dummyRegistryName, this.protocol);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"Cannot get node list for {0}", new Object[]{this.dummyRegistryName, e});
                throw new CMINamingException("Cannot get node list for " + this.dummyRegistryName, e);
            }
            LOGGER.debug((Object)"CMIReferences for dummy context: {0}", new Object[]{loadBalanceables});
        } else {
            lbPolicy = this.defaultPolicy;
            loadBalanceables = this.remoteRegistries;
        }
        while (true) {
            ServerRef loadBalanceable;
            try {
                loadBalanceable = lbPolicy.choose(loadBalanceables);
            }
            catch (NoLoadBalanceableException e) {
                LOGGER.error((Object)"Cannot choose CMIReference in the list {0} with LB policy {1}", new Object[]{loadBalanceables, lbPolicy, e});
                throw new CMINamingException("Cannot choose CMIReference in the list " + loadBalanceables + " with LB policy " + lbPolicy, e);
            }
            ServerRef serverRef = loadBalanceable.getServerRef();
            String pURL = serverRef.getProviderURL();
            LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
            Context context = this.getRealContext(pURL, this.initialContextFactoryName);
            Object object = context.lookupLink(name);
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
            }
            return object;
            catch (NamingException e) {
                block25: {
                    try {
                        LOGGER.debug((Object)"onLookupException: ", new Object[]{e});
                        DecisionManager<Void> decisionManager = lbPolicy.onLookupException(loadBalanceable, e);
                        if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                            LOGGER.debug((Object)"Throw: ", new Object[]{e});
                            throw e;
                        }
                        LOGGER.debug((Object)"Removing node {0}", new Object[]{loadBalanceable});
                        loadBalanceables.remove(loadBalanceable);
                        if (!loadBalanceables.isEmpty()) break block25;
                        LOGGER.debug((Object)"No more load balanceable - Throw: ", new Object[]{e});
                        throw e;
                    }
                    catch (Throwable throwable) {
                        try {
                            context.close();
                        }
                        catch (NamingException e2) {
                            LOGGER.debug((Object)"Unable to close the context", new Object[]{e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    context.close();
                }
                catch (NamingException e3) {
                    LOGGER.debug((Object)"Unable to close the context", new Object[]{e3});
                }
                continue;
            }
            break;
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        LOGGER.debug((Object)"rebind {0}", new Object[]{name});
        if (this.localContext != null) {
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            this.localContext.rebind(name, obj);
            if (this.replicationEnabled && this.clusterViewManager != null && this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE)) {
                try {
                    this.bindIntoCluster(name, obj);
                    LOGGER.debug((Object)"The object for name {0} has been added in the cluster.", new Object[]{name});
                }
                catch (CMIContextException e) {
                    LOGGER.error((Object)"Cannot add the object for name  {0} to the cluster", new Object[]{name});
                    throw new CMINamingException("Cannot add the object for name {0} to the cluster" + name, e);
                }
            } else {
                LOGGER.debug((Object)"Replication is disabled", new Object[0]);
            }
        } else {
            LOGGER.warn((Object)"Cannot rebind because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.localContext != null) {
            return this.localContext.removeFromEnvironment(propName);
        }
        LOGGER.warn((Object)"Cannot removeFromEnvironment because server mode is not activated.", new Object[0]);
        return null;
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        LOGGER.debug((Object)"renaming {0}", new Object[]{oldName, newName});
        if (this.localContext != null) {
            boolean isClustered;
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            if (this.replicationEnabled && this.clusterViewManager != null && this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE) && (isClustered = this.clusterViewManager.isClustered(oldName))) {
                LOGGER.error((Object)"Cannot rename in the cluster for now !", new Object[0]);
                throw new UnsupportedOperationException("Cannot rename in the cluster for now !");
            }
            this.localContext.rename(oldName, newName);
        } else {
            LOGGER.warn((Object)"Cannot rename because server mode is not activated.", new Object[0]);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        LOGGER.debug((Object)"unbind {0}", new Object[]{name});
        if (this.localContext != null) {
            boolean isClustered;
            LOGGER.debug((Object)"Server mode enabled", new Object[0]);
            if (this.replicationEnabled && this.clusterViewManager != null && this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE) && (isClustered = this.clusterViewManager.isClustered(name))) {
                LOGGER.debug((Object)"The object for name {0} has been removed of the cluster.", new Object[]{name});
                ((ServerClusterViewManager)this.clusterViewManager).removeCMIReference(new CMIReference(this.localRegistry, name));
            }
            this.localContext.unbind(name);
        } else {
            LOGGER.warn((Object)"Cannot unbind because server mode is not activated.", new Object[0]);
        }
    }

    private void bindIntoCluster(String name, Object obj) throws CMIContextException {
        ClusteredObjectInfo clusteredObjectInfo;
        if (obj instanceof ClusteredObject) {
            ClusteredObject clusteredObject = (ClusteredObject)obj;
            clusteredObjectInfo = clusteredObject.getClusteredObjectInfo();
        } else if (CMIInfoRepository.containClusteredObjectInfo(name)) {
            clusteredObjectInfo = CMIInfoRepository.getClusteredObjectInfo(name);
        } else {
            LOGGER.debug((Object)"The object for name {0} will not be replicated.", new Object[]{name});
            return;
        }
        if (clusteredObjectInfo.isReplicated() && !((ServerClusterViewManager)this.clusterViewManager).isReplicationManagerStarted()) {
            LOGGER.warn((Object)"the replication manager should be started because the clustered object {0}has a state that must be replicated.", new Object[]{name});
        }
        CMIReference cmiReference = new CMIReference(this.localRegistry, name);
        try {
            ((ServerClusterViewManager)this.clusterViewManager).addObjectInstance(clusteredObjectInfo, cmiReference);
        }
        catch (ServerClusterViewManagerException e) {
            LOGGER.error((Object)"Cannot insert {0} into the cluster view", new Object[]{name, e});
            throw new CMIContextException("Cannot insert " + name + " into the cluster view", e);
        }
    }

    private void setDefaultPolicy() throws CMIContextException {
        try {
            this.defaultPolicy = new FirstAvailable<ServerRef>();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot construct the default policy", new Object[]{e});
            throw new CMIContextException("Cannot construct the default policy", e);
        }
    }

    private Context getRealContext(String providerUrl, String initialContextFactoryName) throws CMINamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactoryName);
        env.put("java.naming.provider.url", providerUrl);
        try {
            return new InitialContext(env);
        }
        catch (NamingException e) {
            throw new CMINamingException("Cannot create an initial context", e);
        }
    }

    protected void register() throws CMIContextException {
        if (this.clusterViewManager != null && !(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Cannot register a registry for client managers", new Object[0]);
            throw new CMIContextException("Cannot register a registry for client managers");
        }
        if (this.clusterViewManager != null && ((ServerClusterViewManager)this.clusterViewManager).isRegistrationOpened() && (this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.STARTING) || this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.STARTED) || this.clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE))) {
            try {
                if (((ServerClusterViewManager)this.clusterViewManager).addProtocol(this.initialContextFactoryName, this.localRegistry, this)) {
                    this.notCloseable = true;
                }
            }
            catch (ServerClusterViewManagerException e) {
                LOGGER.error((Object)"Cannot register the local registry", new Object[]{e});
                throw new CMIContextException("Cannot register the local registry", e);
            }
        }
    }

    private Object findClusteredObject(String name) throws CMIContextException {
        try {
            CMIProxy cmiProxy;
            this.clusterViewManager.addObjectToWatch(name);
            if (!this.clusterViewManager.isProxyEnabled(name)) {
                try {
                    return this.findStubOrProxy(name);
                }
                catch (NamingException e) {
                    LOGGER.error((Object)"Cannot get a proxy (or stub) for {0}.", new Object[]{name, e});
                    throw new CMIContextException("Cannot get a proxy (or stub) for " + name, e);
                }
            }
            try {
                cmiProxy = CMIProxyFactory.newCMIProxy(this.clusterViewManager, name, this.protocol);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot get a CMI proxy for {0}.", new Object[]{name, e});
                throw new CMIContextException("Cannot get a CMI proxy for " + name, e);
            }
            return cmiProxy;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot find the clustered object object {0}", new Object[]{name, e});
            throw new CMIContextException("Cannot find the clustered object object " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findStubOrProxy(String objectName) throws CMIContextException, ObjectNotFoundException, NamingException {
        Object object;
        CMIReference cmiReference;
        Collection<CMIReference> cmiReferences = this.clusterViewManager.getCMIReferences(objectName, this.protocol);
        IPolicy<CMIReference> policy = this.clusterViewManager.getPolicy(objectName);
        try {
            cmiReference = policy.choose(cmiReferences);
        }
        catch (NoLoadBalanceableException e) {
            LOGGER.error((Object)"Cannot choose a CMIReference in the list {0} with LB policy {1}", new Object[]{cmiReferences, policy, e});
            throw new CMIContextException("Cannot choose a CMIReference in the list " + cmiReferences + " with LB policy " + policy, e);
        }
        ServerRef serverRef = cmiReference.getServerRef();
        String pURL = serverRef.getProviderURL();
        LOGGER.debug((Object)"Chosen providerURL: {0}", new Object[]{pURL});
        Context context = this.getRealContext(pURL, this.initialContextFactoryName);
        try {
            object = context.lookup(objectName);
        }
        catch (Throwable throwable) {
            try {
                context.close();
            }
            catch (NamingException e) {
                LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
            }
            throw throwable;
        }
        try {
            context.close();
        }
        catch (NamingException e) {
            LOGGER.debug((Object)"Unable to close the context", new Object[]{e});
        }
        return object;
    }
}

