/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.http;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.transport.http.WSDLQueryHandler;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASWSDLQueryHandler
extends WSDLQueryHandler {
    private static Log logger = LogFactory.getLog(JOnASWSDLQueryHandler.class);
    private String portBindingURI = null;
    private EndpointInfo endpointInfo;
    private WebservicesContainer container;

    public JOnASWSDLQueryHandler(Bus bus, String portBindingURI) {
        super(bus);
        this.portBindingURI = portBindingURI;
    }

    public JOnASWSDLQueryHandler(Bus bus, String url, EndpointInfo ei, WebservicesContainer container) {
        this(bus, url);
        this.endpointInfo = ei;
        this.container = container;
    }

    protected void updateDefinition(Definition definition, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo endpointInfo) {
        QName serviceName = endpointInfo.getService().getName();
        Service serv = definition.getService(serviceName);
        if (serv != null) {
            Collection ports = serv.getPorts().values();
            for (Port port : ports) {
                ExtensibilityElement el;
                List exts = port.getExtensibilityElements();
                if (exts == null || exts.size() <= 0 || !SOAPBindingUtil.isSOAPAddress((Object)(el = (ExtensibilityElement)exts.get(0)))) continue;
                SoapAddress add = SOAPBindingUtil.getSoapAddress((Object)el);
                if (this.isPortMatching(endpointInfo, serviceName, port.getName())) {
                    add.setLocationURI(this.portBindingURI);
                    logger.debug((Object)"Updated ''{0}'' location to ''{1}''", new Object[]{port, this.portBindingURI});
                    continue;
                }
                String url = this.container.findUpdatedURL(new PortIdentifier(serviceName, port.getName()));
                if (url != null) {
                    add.setLocationURI(url);
                    logger.debug((Object)"Updated ''{0}'' location to ''{1}''", new Object[]{port, url});
                    continue;
                }
                add.setLocationURI(this.portBindingURI);
                logger.debug((Object)"Updated ''{0}'' location to ''{1}''", new Object[]{port, this.portBindingURI});
            }
        }
        super.updateDefinition(definition, done, doneSchemas, base, endpointInfo);
    }

    private boolean isPortMatching(EndpointInfo info, QName serviceName, String name) {
        return serviceName.equals(info.getService().getName()) && name.equals(info.getName().getLocalPart());
    }
}

