/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.configurator.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.ow2.util.scan.api.IAnnotationVisitor;
import org.ow2.util.scan.api.configurator.BasicConfigurator;
import org.ow2.util.scan.api.configurator.IClassConfigurator;
import org.ow2.util.scan.api.configurator.IFieldConfigurator;
import org.ow2.util.scan.api.configurator.IMethodConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.AnnotationVisitorDispatcher;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificArchiveConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificClassConfigurator;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IFieldMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JAnnotation;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMetadataConfigurator<C extends IClassMetadata<C, M, F>, M extends IMethodMetadata<C, M, F>, F extends IFieldMetadata<C, M, F>>
extends BasicConfigurator
implements IClassConfigurator {
    private C classMetadata;
    private List<ISpecificClassConfigurator<C, M, F>> specificClassConfiguratorList;

    protected C getClassMetadata() {
        return this.classMetadata;
    }

    public ClassMetadataConfigurator(C classMetadata) {
        this.classMetadata = classMetadata;
        this.specificClassConfiguratorList = new ArrayList<ISpecificClassConfigurator<C, M, F>>();
    }

    public ClassMetadataConfigurator(C classMetadata, List<? extends ISpecificArchiveConfigurator<C, M, F>> specificArchiveConfiguratorList) {
        this.classMetadata = classMetadata;
        this.specificClassConfiguratorList = new ArrayList<ISpecificClassConfigurator<C, M, F>>();
        if (specificArchiveConfiguratorList != null) {
            for (ISpecificArchiveConfigurator<C, M, F> specificArchiveConfigurator : specificArchiveConfiguratorList) {
                this.specificClassConfiguratorList.add(specificArchiveConfigurator.createSpecificClassConfigurator(classMetadata));
            }
        }
    }

    @Override
    public final IMethodConfigurator createMethodConfigurator(JMethod jMethod) {
        return this.createMethodMetadataConfigurator(jMethod);
    }

    protected abstract IMethodConfigurator createMethodMetadataConfigurator(JMethod var1);

    @Override
    public final IFieldConfigurator createFieldConfigurator(JField jField) {
        return this.createFieldMetadataConfigurator(jField);
    }

    protected abstract IFieldConfigurator createFieldMetadataConfigurator(JField var1);

    @Override
    public IAnnotationVisitor getAnnotationVisitor(JAnnotation annotation) {
        ArrayList<IAnnotationVisitor> annotationVisitorList = new ArrayList<IAnnotationVisitor>();
        IAnnotationVisitor annotationVisitor = super.getAnnotationVisitor(annotation);
        if (annotationVisitor != null) {
            annotationVisitorList.add(annotationVisitor);
        }
        for (ISpecificClassConfigurator<C, M, F> specificClassConfigurator : this.specificClassConfiguratorList) {
            annotationVisitor = specificClassConfigurator.getAnnotationVisitor(annotation);
            if (annotationVisitor == null) continue;
            annotationVisitorList.add(annotationVisitor);
        }
        switch (annotationVisitorList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IAnnotationVisitor)annotationVisitorList.get(0);
            }
        }
        return new AnnotationVisitorDispatcher(annotationVisitorList);
    }

    @Override
    public void configurationComplete(Set<String> referencedClasses) {
        String superName;
        for (ISpecificClassConfigurator<C, M, F> specificClassConfigurator : this.specificClassConfiguratorList) {
            specificClassConfigurator.configurationComplete(referencedClasses);
        }
        String[] interfaces = this.classMetadata.getJClass().getInterfaces();
        if (interfaces != null) {
            referencedClasses.addAll(Arrays.asList(interfaces));
        }
        if (!(superName = this.classMetadata.getJClass().getSuperName()).equals("java/lang/Object")) {
            referencedClasses.add(superName);
        }
        super.configurationComplete(referencedClasses);
    }

    protected List<ISpecificClassConfigurator<C, M, F>> getSpecificClassConfiguratorList() {
        return this.specificClassConfiguratorList;
    }
}

