/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EntityBean;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.xml.Method;
import org.ow2.jonas.deployment.ejb.xml.MethodParams;

public class MethodDesc {
    public static final int TX_NULL = -1;
    public static final int TX_NOT_SET = 0;
    public static final int TX_NOT_SUPPORTED = 1;
    public static final int TX_REQUIRED = 2;
    public static final int TX_SUPPORTS = 3;
    public static final int TX_REQUIRES_NEW = 4;
    public static final int TX_MANDATORY = 5;
    public static final int TX_NEVER = 6;
    private static final String[] ATTR = new String[]{"TX_NOT_SET", "TX_NOT_SUPPORTED", "TX_REQUIRED", "TX_SUPPORTS", "TX_REQUIRES_NEW", "TX_MANDATORY", "TX_NEVER"};
    protected static final String TX_STR_DEFAULT_VALUE = "Supports";
    protected static final String TX_STR_DEFAULT_VALUE_4_MDB = "NotSupported";
    private int txAttribute = 0;
    private int txAttributeStatus = 1;
    private HashSet roleName = new HashSet();
    public static final int APPLY_TO_NOTHING = 0;
    public static final int APPLY_TO_BEAN = 1;
    public static final int APPLY_TO_CLASS = 2;
    public static final int APPLY_TO_BEAN_METHOD_NAME = 3;
    public static final int APPLY_TO_CLASS_METHOD_NAME = 4;
    public static final int APPLY_TO_BEAN_METHOD = 5;
    public static final int APPLY_TO_CLASS_METHOD = 6;
    protected static final String[] APPLY_TO = new String[]{"APPLY_TO_NOTHING", "APPLY_TO_BEAN", "APPLY_TO_CLASS", "APPLY_TO_BEAN_METHOD_NAME", "APPLY_TO_CLASS_METHOD_NAME", "APPLY_TO_BEAN_METHOD", "APPLY_TO_CLASS_METHOD"};
    private java.lang.reflect.Method meth;
    private Class classDef;
    private int index;
    protected BeanDesc beanDesc;
    private boolean isFinder = false;
    private boolean isEjbSelect = false;
    private boolean isFindByPrimaryKey = false;
    private boolean excluded = false;

    public MethodDesc(BeanDesc beanDesc, java.lang.reflect.Method meth, Class clDef, int index) {
        this.meth = meth;
        this.classDef = clDef;
        this.index = index;
        this.beanDesc = beanDesc;
        this.isFindByPrimaryKey = MethodDesc.isFindByPrimaryKey(meth);
        this.isFinder = MethodDesc.isFinder(meth);
        this.isEjbSelect = MethodDesc.isEjbSelect(meth);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public boolean isFinder() {
        return this.isFinder;
    }

    public boolean isFindByPrimaryKey() {
        return this.isFindByPrimaryKey;
    }

    public boolean isEjbSelect() {
        return this.isEjbSelect;
    }

    void overwriteTxAttribute(String transAttribute, int status) throws DeploymentDescException {
        if (status < this.txAttributeStatus) {
            return;
        }
        this.setTxAttribute(transAttribute);
        this.txAttributeStatus = status;
    }

    void setTxAttribute(String transAttribute) throws DeploymentDescException {
        if (transAttribute.equals(TX_STR_DEFAULT_VALUE_4_MDB)) {
            this.txAttribute = 1;
        } else if (transAttribute.equals("Required")) {
            this.txAttribute = 2;
        } else if (transAttribute.equals(TX_STR_DEFAULT_VALUE)) {
            this.txAttribute = 3;
        } else if (transAttribute.equals("RequiresNew")) {
            this.txAttribute = 4;
        } else if (transAttribute.equals("Mandatory")) {
            this.txAttribute = 5;
        } else if (transAttribute.equals("Never")) {
            this.txAttribute = 6;
        } else {
            throw new DeploymentDescException(transAttribute + " is not a valid trans-attribute value");
        }
    }

    void addRoleName(String rn) {
        this.roleName.add(rn);
    }

    public int matchPattern(Class pclass, String mName, MethodParams patternMethodParams) {
        return MethodDesc.matchPattern(this.getMethod(), this.classDef, pclass, mName, patternMethodParams);
    }

    public static int matchPattern(java.lang.reflect.Method meth, Class classMeth, Class pclass, String mName, MethodParams patternMethodParams) {
        JLinkedList pattPars;
        if (pclass != null && !pclass.isAssignableFrom(classMeth)) {
            return 0;
        }
        if (mName.equals("*")) {
            return pclass == null ? 1 : 2;
        }
        if (!mName.equals(meth.getName())) {
            return 0;
        }
        if (patternMethodParams == null) {
            return pclass == null ? 3 : 4;
        }
        Class<?>[] pars = meth.getParameterTypes();
        if (pars.length != (pattPars = patternMethodParams.getMethodParamList()).size()) {
            return 0;
        }
        Iterator i = pattPars.iterator();
        for (int ii = 0; ii < pars.length; ++ii) {
            String cName = (String)i.next();
            if (MethodDesc.getClassName(pars[ii]).equals(cName)) continue;
            return 0;
        }
        return pclass == null ? 5 : 6;
    }

    private static String getClassName(Class c) {
        String name = c.isArray() ? MethodDesc.getClassName(c.getComponentType()) + "[]" : c.getName();
        return name;
    }

    public int getTxAttribute() {
        return this.txAttribute;
    }

    public int getTxAttributeStatus() {
        return this.txAttributeStatus;
    }

    public static String getTxAttributeName(int value) {
        if (value < 0 || value > ATTR.length) {
            throw new Error(value + " is not a valid TxAttribute");
        }
        return ATTR[value];
    }

    public String getTxAttributeName() {
        return ATTR[this.txAttribute];
    }

    public String[] getRoleName() {
        if (this.roleName.isEmpty()) {
            return new String[0];
        }
        Object[] o = this.roleName.toArray();
        String[] rn = new String[o.length];
        for (int i = 0; i < rn.length; ++i) {
            rn[i] = (String)o[i];
        }
        return rn;
    }

    public static String methodElementToString(Method m) {
        return MethodDesc.methodElementToString(m.getMethodIntf(), m.getMethodName(), m.getMethodParams());
    }

    protected static String methodElementToString(String intf, String name, MethodParams params) {
        String s = new String();
        if (intf != null) {
            s = s.concat(intf + ".");
        }
        s = s.concat(name);
        if (params != null) {
            s = s.concat("(");
            Iterator i = params.getMethodParamList().iterator();
            while (i.hasNext()) {
                s = s.concat((String)i.next());
                if (!i.hasNext()) continue;
                s = s.concat(",");
            }
            s = s.concat(")");
        }
        return s;
    }

    public static String toString(java.lang.reflect.Method m) {
        StringBuffer ret = new StringBuffer();
        ret.append(m.getDeclaringClass().getName());
        ret.append('.');
        ret.append(m.getName());
        ret.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            ret.append(MethodDesc.getClassName(params[i]));
            if (i == params.length - 1) break;
            ret.append(',');
        }
        ret.append(')');
        return ret.toString();
    }

    public java.lang.reflect.Method getMethod() {
        return this.meth;
    }

    public BeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    public static boolean isFinder(java.lang.reflect.Method meth) {
        return meth.getName().startsWith("find") && (EJBHome.class.isAssignableFrom(meth.getDeclaringClass()) || EJBLocalHome.class.isAssignableFrom(meth.getDeclaringClass()));
    }

    public static boolean isFindByPrimaryKey(java.lang.reflect.Method meth) {
        return meth.getName().equals("findByPrimaryKey") && (EJBHome.class.isAssignableFrom(meth.getDeclaringClass()) || EJBLocalHome.class.isAssignableFrom(meth.getDeclaringClass()));
    }

    public static boolean isEjbSelect(java.lang.reflect.Method meth) {
        return meth.getName().startsWith("ejbSelect") && EntityBean.class.isAssignableFrom(meth.getDeclaringClass());
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetTxAttribute()       = " + ATTR[this.getTxAttribute()]);
        ret.append("\ngetTxAttributeStatus() = " + APPLY_TO[this.getTxAttributeStatus()]);
        ret.append("\nMethodIndex            = " + this.index);
        ret.append("\nmeth                   = " + MethodDesc.toString(this.meth));
        ret.append("\nisFinder               = " + this.isFinder);
        ret.append("\nisEjbSelect            = " + this.isEjbSelect);
        ret.append("\nisFindByPrimaryKey     = " + this.isFindByPrimaryKey);
        if (!this.roleName.isEmpty()) {
            ret.append("\ngetRoleName()          = [");
            String[] rn = this.getRoleName();
            for (int i = 0; i < rn.length - 1; ++i) {
                ret.append(rn[i] + ", ");
            }
            ret.append(rn[rn.length - 1] + "]");
            ret.append("\n");
        }
        return ret.toString();
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }
}

