/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import javax.security.jacc.HttpMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebResourcePermission
extends Permission
implements Serializable {
    private transient HttpMethodSpec methodSpec;
    private transient URLPatternSpec urlPatternSpec = null;
    private transient int hashCodeValue = 0;
    private static final transient String EMPTY_STRING = "";
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};

    public WebResourcePermission(String name, String actions2) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.methodSpec = HttpMethodSpec.getSpec(actions2);
    }

    public WebResourcePermission(String urlPatternSpec, String[] HTTPMethods) {
        super(urlPatternSpec);
        this.urlPatternSpec = new URLPatternSpec(urlPatternSpec);
        this.methodSpec = HttpMethodSpec.getSpec(HTTPMethods);
    }

    public WebResourcePermission(HttpServletRequest request) {
        super(WebResourcePermission.getUriMinusContextPath(request));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.methodSpec = HttpMethodSpec.getSpec(request.getMethod());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)o;
        if (!this.methodSpec.equals(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(that.urlPatternSpec);
    }

    public String getActions() {
        return this.methodSpec.getActions();
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String hashInput = new String(this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode());
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)permission;
        if (!this.methodSpec.implies(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(that.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri != null) {
            int contextLength;
            String contextPath = request.getContextPath();
            int n = contextLength = contextPath == null ? 0 : contextPath.length();
            if (contextLength > 0) {
                uri = uri.substring(contextLength);
            }
            if (uri.equals("/")) {
                uri = EMPTY_STRING;
            }
        } else {
            uri = EMPTY_STRING;
        }
        return uri;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.methodSpec = HttpMethodSpec.getSpec((String)s.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields().put("actions", this.getActions());
        s.writeFields();
    }
}

