/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXOMBuilder
extends StAXBuilder {
    private static final Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$builder$StAXOMBuilder == null ? (class$org$apache$axiom$om$impl$builder$StAXOMBuilder = StAXOMBuilder.class$("org.apache.axiom.om.impl.builder.StAXOMBuilder")) : class$org$apache$axiom$om$impl$builder$StAXOMBuilder);
    private boolean doTrace = log.isDebugEnabled();
    private static int nsCount = 0;
    boolean namespaceURIInterning = false;
    int lookAheadToken = -1;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$builder$StAXOMBuilder;

    public StAXOMBuilder(OMFactory ombuilderFactory, XMLStreamReader parser2) {
        super(ombuilderFactory, parser2);
        this.document = ombuilderFactory.createOMDocument(this);
        if (this.charEncoding != null) {
            this.document.setCharsetEncoding(this.charEncoding);
        }
    }

    public StAXOMBuilder(OMFactory factory, XMLStreamReader parser2, OMElement element, String characterEncoding) {
        super(factory, parser2, characterEncoding);
        this.document = factory.createOMDocument(this);
        if (this.charEncoding != null) {
            this.document.setCharsetEncoding(this.charEncoding);
        }
        this.lastNode = element;
        this.document.setOMDocumentElement(element);
        this.populateOMElement(element);
    }

    public StAXOMBuilder(OMFactory factory, XMLStreamReader parser2, OMElement element) {
        this(factory, parser2, element, null);
    }

    public StAXOMBuilder(String filePath) throws XMLStreamException, FileNotFoundException {
        this(StAXUtils.createXMLStreamReader(new FileInputStream(filePath)));
    }

    public StAXOMBuilder(XMLStreamReader parser2) {
        super(parser2);
        this.omfactory = OMAbstractFactory.getOMFactory();
        this.document = this.omfactory.createOMDocument(this);
        if (this.charEncoding != null) {
            this.document.setCharsetEncoding(this.charEncoding);
        }
    }

    public StAXOMBuilder(InputStream inStream) throws XMLStreamException {
        this(StAXUtils.createXMLStreamReader(inStream));
    }

    public StAXOMBuilder() {
    }

    public int next() throws OMException {
        try {
            if (this.done) {
                throw new OMException();
            }
            int token = this.parserNext();
            if (!this.cache) {
                return token;
            }
            switch (token) {
                case 1: {
                    if (this.doTrace) {
                        log.trace("START_ELEMENT: " + this.parser.getName() + ":" + this.parser.getLocalName());
                    }
                    ++this.elementLevel;
                    this.lastNode = this.createNextOMElement();
                    break;
                }
                case 7: {
                    this.document.setXMLVersion(this.parser.getVersion());
                    this.document.setCharsetEncoding(this.parser.getEncoding());
                    this.document.setStandalone(this.parser.isStandalone() ? "yes" : "no");
                    if (!this.doTrace) break;
                    log.trace("START_DOCUMENT: ");
                    break;
                }
                case 4: {
                    if (this.doTrace) {
                        log.trace("CHARACTERS: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(4);
                    break;
                }
                case 12: {
                    if (this.doTrace) {
                        log.trace("CDATA: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(12);
                    break;
                }
                case 2: {
                    if (this.doTrace) {
                        log.trace("END_ELEMENT: " + this.parser.getName() + ":" + this.parser.getLocalName());
                    }
                    this.endElement();
                    --this.elementLevel;
                    break;
                }
                case 8: {
                    if (this.doTrace) {
                        log.trace("END_DOCUMENT: ");
                    }
                    this.done = true;
                    ((OMContainerEx)((Object)this.document)).setComplete(true);
                    break;
                }
                case 6: {
                    if (this.doTrace) {
                        log.trace("SPACE: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(6);
                    break;
                }
                case 5: {
                    if (this.doTrace) {
                        log.trace("COMMENT: [" + this.parser.getText() + "]");
                    }
                    this.createComment();
                    break;
                }
                case 11: {
                    if (this.doTrace) {
                        log.trace("DTD: [" + this.parser.getText() + "]");
                    }
                    this.createDTD();
                    break;
                }
                case 3: {
                    if (this.doTrace) {
                        log.trace("PROCESSING_INSTRUCTION: [" + this.parser.getPITarget() + "][" + this.parser.getPIData() + "]");
                    }
                    this.createPI();
                    break;
                }
                case 9: {
                    if (this.doTrace) {
                        log.trace("ENTITY_REFERENCE: " + this.parser.getLocalName() + "[" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(9);
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
            return token;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    protected OMNode createNextOMElement() {
        String localPart;
        String namespace;
        CustomBuilder customBuilder;
        OMNode newElement = null;
        if (this.elementLevel == 1 && this.customBuilderForPayload != null) {
            newElement = this.createWithCustomBuilder(this.customBuilderForPayload, this.omfactory);
        } else if (this.customBuilders != null && this.elementLevel <= this.maxDepthForCustomBuilders && (customBuilder = this.getCustomBuilder(namespace = this.parser.getNamespaceURI(), localPart = this.parser.getLocalName())) != null) {
            newElement = this.createWithCustomBuilder(customBuilder, this.omfactory);
        }
        if (newElement == null) {
            newElement = this.createOMElement();
        } else {
            --this.elementLevel;
        }
        return newElement;
    }

    protected OMNode createWithCustomBuilder(CustomBuilder customBuilder, OMFactory factory) {
        String namespace = this.parser.getNamespaceURI();
        String localPart = this.parser.getLocalName();
        OMContainer parent = null;
        parent = this.lastNode != null ? (this.lastNode.isComplete() ? this.lastNode.getParent() : (OMContainer)((Object)this.lastNode)) : this.document;
        return customBuilder.create(namespace, localPart, parent, this.parser, factory);
    }

    private void populateOMElement(OMElement node) {
        this.processNamespaceData(node);
        this.processAttributes(node);
        Location location = this.parser.getLocation();
        if (location != null) {
            node.setLineNumber(location.getLineNumber());
        }
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.omfactory.createOMElement(elementName, null, this.document, this);
        } else if (this.lastNode.isComplete()) {
            node = this.omfactory.createOMElement(elementName, null, this.lastNode.getParent(), this);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMContainerEx e = (OMContainerEx)((Object)this.lastNode);
            node = this.omfactory.createOMElement(elementName, null, (OMElement)this.lastNode, this);
            e.setFirstChild(node);
        }
        this.populateOMElement(node);
        return node;
    }

    protected OMNode createComment() throws OMException {
        OMComment node = this.lastNode == null ? this.omfactory.createOMComment(this.document, this.parser.getText()) : (this.lastNode.isComplete() ? this.omfactory.createOMComment(this.lastNode.getParent(), this.parser.getText()) : this.omfactory.createOMComment((OMElement)this.lastNode, this.parser.getText()));
        return node;
    }

    protected OMNode createDTD() throws OMException {
        if (!this.parser.hasText()) {
            return null;
        }
        this.lastNode = this.omfactory.createOMDocType(this.document, this.parser.getText());
        return this.lastNode;
    }

    protected OMNode createPI() throws OMException {
        String target = this.parser.getPITarget();
        String data = this.parser.getPIData();
        OMProcessingInstruction node = this.lastNode == null ? this.omfactory.createOMProcessingInstruction(this.document, target, data) : (this.lastNode.isComplete() ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : (this.lastNode instanceof OMText ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : this.omfactory.createOMProcessingInstruction((OMContainer)((Object)this.lastNode), target, data)));
        return node;
    }

    protected void endElement() {
        if (this.lastNode.isComplete()) {
            OMNodeEx parent = (OMNodeEx)((Object)this.lastNode.getParent());
            parent.setComplete(true);
            this.lastNode = parent;
        } else {
            OMNodeEx e = (OMNodeEx)this.lastNode;
            e.setComplete(true);
        }
    }

    public OMElement getDocumentElement() {
        return this.document.getOMDocumentElement();
    }

    protected void processNamespaceData(OMElement node) {
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String nsprefix = this.parser.getNamespacePrefix(i);
            String namespaceURIFromParser = this.parser.getNamespaceURI(i);
            if (nsprefix == null || "".equals(nsprefix)) {
                node.declareDefaultNamespace(this.parser.getNamespaceURI(i));
                continue;
            }
            if (this.isNamespaceURIInterning()) {
                namespaceURIFromParser = namespaceURIFromParser.intern();
            }
            node.declareNamespace(namespaceURIFromParser, nsprefix);
        }
        if (namespaceURI != null && namespaceURI.length() > 0) {
            OMNamespace namespace = node.findNamespace(namespaceURI, prefix);
            if (namespace == null || !namespace.getPrefix().equals(prefix)) {
                if (this.isNamespaceURIInterning()) {
                    namespaceURI = namespaceURI.intern();
                }
                namespace = prefix == null || "".equals(prefix) ? node.declareDefaultNamespace(namespaceURI) : node.declareNamespace(namespaceURI, prefix);
            }
            node.setNamespaceWithNoFindInCurrentScope(namespace);
        }
    }

    public void setDoDebug(boolean doDebug) {
        this.doTrace = doDebug;
    }

    protected String createPrefix() {
        return "ns" + nsCount++;
    }

    public void setNamespaceURIInterning(boolean b) {
        this.namespaceURIInterning = b;
    }

    public boolean isNamespaceURIInterning() {
        return this.namespaceURIInterning;
    }

    private int parserNext() throws XMLStreamException {
        if (this.lookAheadToken >= 0) {
            int token = this.lookAheadToken;
            this.lookAheadToken = -1;
            return token;
        }
        return this.parser.next();
    }

    public boolean lookahead() {
        try {
            while (true) {
                if (this.lookAheadToken < 0) {
                    this.lookAheadToken = this.parserNext();
                }
                if (this.lookAheadToken == 1) {
                    return true;
                }
                if (this.lookAheadToken == 2 || this.lookAheadToken == 7 || this.lookAheadToken == 8) {
                    this.next();
                    return false;
                }
                this.next();
            }
        }
        catch (XMLStreamException e) {
            throw new OMException(e);
        }
    }

    public boolean isLookahead() {
        return this.lookAheadToken >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

