/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.xmlschema.FixedExtensionDeserializer;
import org.apache.cxf.common.xmlschema.InvalidXmlSchemaReferenceException;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.TargetNamespaceValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SchemaCollection {
    private static final Method GET_ELEMENT_BY_NAME_METHOD;
    private XmlSchemaCollection schemaCollection;

    public SchemaCollection() {
        this(new XmlSchemaCollection());
    }

    public SchemaCollection(XmlSchemaCollection col) {
        this.schemaCollection = col;
        col.getExtReg().setDefaultExtensionDeserializer(new FixedExtensionDeserializer());
        if (this.schemaCollection.getNamespaceContext() == null) {
            this.schemaCollection.setNamespaceContext(new NamespaceMap());
        }
    }

    public boolean equals(Object obj) {
        return this.schemaCollection.equals(obj);
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        return this.schemaCollection.getElementByQName(qname);
    }

    public ExtensionRegistry getExtReg() {
        return this.schemaCollection.getExtReg();
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.schemaCollection.getNamespaceContext();
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        XmlSchemaType xst = this.schemaCollection.getTypeByQName(schemaTypeName);
        if (xst == null && "http://www.w3.org/2001/XMLSchema".equals(schemaTypeName.getNamespaceURI())) {
            XmlSchema sch = this.getSchemaByTargetNamespace(schemaTypeName.getNamespaceURI());
            if ("anySimpleType".equals(schemaTypeName.getLocalPart())) {
                XmlSchemaSimpleType type = new XmlSchemaSimpleType(sch);
                type.setName(schemaTypeName.getLocalPart());
                sch.addType(type);
                xst = type;
            } else if ("anyType".equals(schemaTypeName.getLocalPart())) {
                XmlSchemaType type = new XmlSchemaType(sch);
                type.setName(schemaTypeName.getLocalPart());
                sch.addType(type);
                xst = type;
            }
        }
        return xst;
    }

    public XmlSchema[] getXmlSchema(String systemId) {
        return this.schemaCollection.getXmlSchema(systemId);
    }

    public XmlSchema[] getXmlSchemas() {
        return this.schemaCollection.getXmlSchemas();
    }

    public int hashCode() {
        return this.schemaCollection.hashCode();
    }

    public void init() {
        this.schemaCollection.init();
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh, TargetNamespaceValidator validator) {
        return this.schemaCollection.read(doc, uri, veh, validator);
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh) {
        return this.schemaCollection.read(doc, uri, veh);
    }

    public XmlSchema read(Document doc, ValidationEventHandler veh) {
        return this.schemaCollection.read(doc, veh);
    }

    public XmlSchema read(Element elem, String uri) {
        return this.schemaCollection.read(elem, uri);
    }

    public XmlSchema read(Element elem) {
        return this.schemaCollection.read(elem);
    }

    public XmlSchema read(InputSource inputSource, ValidationEventHandler veh) {
        return this.schemaCollection.read(inputSource, veh);
    }

    public XmlSchema read(Reader r, ValidationEventHandler veh) {
        return this.schemaCollection.read(r, veh);
    }

    public XmlSchema read(Source source, ValidationEventHandler veh) {
        return this.schemaCollection.read(source, veh);
    }

    public void setBaseUri(String baseUri) {
        this.schemaCollection.setBaseUri(baseUri);
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.schemaCollection.setExtReg(extReg);
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.schemaCollection.setNamespaceContext(namespaceContext);
    }

    public void setSchemaResolver(URIResolver schemaResolver) {
        this.schemaCollection.setSchemaResolver(schemaResolver);
    }

    public XmlSchema getSchemaByTargetNamespace(String namespaceURI) {
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!schema.getTargetNamespace().equals(namespaceURI)) continue;
            return schema;
        }
        return null;
    }

    public XmlSchema getSchemaForElement(QName name) {
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!name.getNamespaceURI().equals(schema.getTargetNamespace())) continue;
            try {
                if (!(GET_ELEMENT_BY_NAME_METHOD != null ? GET_ELEMENT_BY_NAME_METHOD.invoke((Object)schema, name.getLocalPart()) != null : schema.getElementByName(name) != null)) continue;
                return schema;
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public XmlSchema newXmlSchemaInCollection(String namespaceURI) {
        StringBuffer tinyXmlSchemaDocument = new StringBuffer();
        tinyXmlSchemaDocument.append("<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema' ");
        tinyXmlSchemaDocument.append("targetNamespace='" + namespaceURI + "'/>");
        StringReader reader = new StringReader(tinyXmlSchemaDocument.toString());
        return this.schemaCollection.read(reader, new ValidationEventHandler(){});
    }

    public void validateQNameNamespace(QName qname) {
        if ("".equals(qname.getNamespaceURI())) {
            return;
        }
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (!schema.getTargetNamespace().equals(qname.getNamespaceURI())) continue;
            return;
        }
        throw new InvalidXmlSchemaReferenceException(qname + " refers to unknown namespace.");
    }

    public void validateElementName(QName referrer, QName elementQName) {
        XmlSchemaElement element = this.schemaCollection.getElementByQName(elementQName);
        if (element == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent element " + elementQName);
        }
    }

    public void validateTypeName(QName referrer, QName typeQName) {
        XmlSchemaType type = this.schemaCollection.getTypeByQName(typeQName);
        if (type == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent type " + typeQName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalElementToSchema(XmlSchemaElement element) {
        SchemaCollection schemaCollection = this;
        synchronized (schemaCollection) {
            XmlSchema schema = this.getSchemaByTargetNamespace(element.getQName().getNamespaceURI());
            if (schema == null) {
                schema = this.newXmlSchemaInCollection(element.getQName().getNamespaceURI());
            }
            schema.getItems().add(element);
            schema.getElements().add(element.getQName(), element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalElementToSchema(XmlSchema schema, XmlSchemaElement element) {
        XmlSchema xmlSchema = schema;
        synchronized (xmlSchema) {
            schema.getItems().add(element);
            schema.getElements().add(element.getQName(), element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalTypeToSchema(XmlSchema schema, XmlSchemaType type) {
        XmlSchema xmlSchema = schema;
        synchronized (xmlSchema) {
            schema.getItems().add(type);
            schema.addType(type);
        }
    }

    static {
        Method m = null;
        try {
            m = XmlSchema.class.getMethod("getElementByName", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_ELEMENT_BY_NAME_METHOD = m;
    }
}

