/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSpringBeanMap<X, V>
implements ApplicationContextAware,
InitializingBean,
MapProvider<X, V> {
    protected ApplicationContext context;
    protected Class<?> type;
    protected String idsProperty;
    protected Map<X, List<String>> idToBeanName = new ConcurrentHashMap<X, List<String>>();
    protected Map<X, V> putStore = new ConcurrentHashMap<X, V>();

    AbstractSpringBeanMap() {
    }

    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = ctx;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.processBeans(this.context);
    }

    @Override
    public Map<X, V> createMap() {
        return new SpringBeanMapWrapper();
    }

    protected abstract void processBeans(ApplicationContext var1);

    protected synchronized List<String> getBeanListForId(X id) {
        List<String> lst = this.idToBeanName.get(id);
        if (lst == null) {
            lst = new CopyOnWriteArrayList<String>();
            this.idToBeanName.put(id, lst);
        }
        return lst;
    }

    protected Collection<String> getIds(Object bean) {
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), this.idsProperty);
            Method method = pd.getReadMethod();
            Collection<String> c = CastUtils.cast((Collection)method.invoke(bean, new Object[0]));
            return c;
        }
        catch (IllegalArgumentException e) {
            throw new BeanInitializationException("Could not retrieve ids.", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInitializationException("Could not access id getter.", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInitializationException("Could not invoke id getter.", e);
        }
        catch (SecurityException e) {
            throw new BeanInitializationException("Could not invoke id getter.", e);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getIdsProperty() {
        return this.idsProperty;
    }

    public void setIdsProperty(String idsProperty) {
        this.idsProperty = idsProperty;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.idToBeanName.containsKey(key) || this.putStore.containsKey(key);
    }

    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<X, V>> entrySet() {
        LinkedHashSet<Map.Entry<X, V>> entries = new LinkedHashSet<Map.Entry<X, V>>();
        for (X k : this.keySet()) {
            entries.add(new Entry(this, k));
        }
        return entries;
    }

    public V get(Object key) {
        List<String> names = this.idToBeanName.get(key);
        if (names != null) {
            for (String name : names) {
                this.context.getBean(name);
            }
            if (this.putStore.containsKey(key)) {
                return this.putStore.get(key);
            }
            Object v = this.context.getBean(names.get(0));
            this.putStore.put(key, v);
            this.idToBeanName.remove(key);
            return (V)v;
        }
        return this.putStore.get(key);
    }

    public boolean isEmpty() {
        return this.idToBeanName.isEmpty() && this.putStore.isEmpty();
    }

    public Set<X> keySet() {
        LinkedHashSet<X> keys = new LinkedHashSet<X>();
        keys.addAll(this.putStore.keySet());
        keys.addAll(this.idToBeanName.keySet());
        return keys;
    }

    public V put(X key, V value) {
        this.idToBeanName.remove(key);
        return this.putStore.put(key, value);
    }

    public void putAll(Map<? extends X, ? extends V> m) {
        this.putStore.putAll(m);
    }

    public V remove(Object key) {
        V v = this.get(key);
        if (v != null) {
            this.idToBeanName.remove(key);
        } else {
            v = this.putStore.get(key);
        }
        return v;
    }

    public int size() {
        return this.idToBeanName.size() + this.putStore.size();
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        values.addAll(this.putStore.values());
        for (X id : this.idToBeanName.keySet()) {
            values.add(this.get(id));
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpringBeanMapWrapper
    implements Map<X, V> {
        private SpringBeanMapWrapper() {
        }

        @Override
        public void clear() {
            AbstractSpringBeanMap.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return AbstractSpringBeanMap.this.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return AbstractSpringBeanMap.this.containsValue(value);
        }

        @Override
        public Set<Map.Entry<X, V>> entrySet() {
            return AbstractSpringBeanMap.this.entrySet();
        }

        @Override
        public V get(Object key) {
            return AbstractSpringBeanMap.this.get(key);
        }

        @Override
        public boolean isEmpty() {
            return AbstractSpringBeanMap.this.isEmpty();
        }

        @Override
        public Set<X> keySet() {
            return AbstractSpringBeanMap.this.keySet();
        }

        @Override
        public V put(X key, V value) {
            return AbstractSpringBeanMap.this.put(key, value);
        }

        @Override
        public void putAll(Map<? extends X, ? extends V> t) {
            AbstractSpringBeanMap.this.putAll(t);
        }

        @Override
        public V remove(Object key) {
            return AbstractSpringBeanMap.this.remove(key);
        }

        @Override
        public int size() {
            return AbstractSpringBeanMap.this.size();
        }

        @Override
        public Collection<V> values() {
            return AbstractSpringBeanMap.this.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<X, V>
    implements Map.Entry<X, V> {
        private AbstractSpringBeanMap<X, V> map;
        private X key;

        public Entry(AbstractSpringBeanMap<X, V> map, X key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public X getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.map.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return this.map.put(this.key, value);
        }
    }
}

