/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchLogicalHandlerInterceptor<T extends Message>
extends AbstractJAXWSHandlerInterceptor<T> {
    public DispatchLogicalHandlerInterceptor(Binding binding) {
        super(binding, "pre-marshal");
    }

    public DispatchLogicalHandlerInterceptor(Binding binding, String phase) {
        super(binding, phase);
    }

    @Override
    public void handleMessage(T message) throws Fault {
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (invoker.getLogicalHandlers().isEmpty()) {
            return;
        }
        LogicalMessageContextImpl lctx = new LogicalMessageContextImpl((Message)((Object)message));
        invoker.setLogicalMessageContext(lctx);
        boolean requestor = this.isRequestor(message);
        ContextPropertiesMapping.mapCxf2Jaxws(message.getExchange(), lctx, requestor);
        if (!invoker.invokeLogicalHandlers(requestor, lctx) && requestor && this.isOutbound(message)) {
            message.getInterceptorChain().abort();
            Endpoint e = message.getExchange().get(Endpoint.class);
            Message responseMsg = e.getBinding().createMessage();
            MessageObserver observer = message.getExchange().get(MessageObserver.class);
            if (observer != null) {
                responseMsg.setContent(XMLStreamReader.class, message.getContent(XMLStreamReader.class));
                message.getExchange().setInMessage(responseMsg);
                responseMsg.put("starting_at_interceptor_id", LogicalHandlerInInterceptor.class.getName());
                observer.onMessage(responseMsg);
            }
        }
        if (!this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        }
    }
}

