/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.util.Config;

public class PublisherTable {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$PublisherTable == null ? (class$org$apache$juddi$datastore$jdbc$PublisherTable = PublisherTable.class$("org.apache.juddi.datastore.jdbc.PublisherTable")) : class$org$apache$juddi$datastore$jdbc$PublisherTable);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static String updateSQL = null;
    static String verifyAdminSQL = null;
    static String tablePrefix = "";
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$PublisherTable;

    public static void insert(Publisher publisher, Connection connection) throws SQLException {
        if (publisher == null) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, publisher.getPublisherID());
            statement.setString(2, publisher.getName());
            statement.setString(3, publisher.getEmailAddress());
            statement.setString(4, String.valueOf(publisher.isAdmin()));
            statement.setString(5, String.valueOf(publisher.isEnabled()));
            statement.setInt(6, publisher.getMaxBusinesses());
            statement.setInt(7, publisher.getMaxServicesPerBusiness());
            statement.setInt(8, publisher.getMaxBindingsPerService());
            statement.setInt(9, publisher.getMaxTModels());
            if (log.isDebugEnabled()) {
                log.debug("insert into " + tablePrefix + "PUBLISHER table:\n\n\t" + insertSQL + "\n\t PUBLISHER_ID=" + publisher.getPublisherID() + "\n\t PUBLISHER_NAME=" + publisher.getName() + "\n\t EMAIL_ADDRESS=" + publisher.getEmailAddress() + "\n\t IS_ADMIN=" + publisher.isAdmin() + "\n\t IS_ENABLED=" + publisher.isEnabled() + "\n\t MAX_BUSINESSES=" + publisher.getMaxBusinesses() + "\n\t MAX_SERVICES_PER_BUSINESS=" + publisher.getMaxServicesPerBusiness() + "\n\t MAX_BINDINGS_PER_SERVICE=" + publisher.getMaxBindingsPerService() + "\n\t MAX_TMODELS=" + publisher.getMaxTModels() + "\n");
            }
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Publisher select(String publisherID, Connection connection) throws SQLException {
        if (publisherID == null) {
            return null;
        }
        Publisher publisher = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, publisherID);
            if (log.isDebugEnabled()) {
                log.debug("select from " + tablePrefix + "PUBLISHER table:\n\n\t" + selectSQL + "\n\t PUBLISHER_ID=" + publisherID + "\n");
            }
            if ((resultSet = statement.executeQuery()).next()) {
                publisher = new Publisher();
                publisher.setPublisherID(publisherID);
                publisher.setName(resultSet.getString(1));
                publisher.setEmailAddress(resultSet.getString(2));
                publisher.setAdminValue(resultSet.getString(3));
                publisher.setEnabledValue(resultSet.getString(4));
                publisher.setMaxBusinesses(resultSet.getInt(5));
                publisher.setMaxServicesPerBusiness(resultSet.getInt(6));
                publisher.setMaxBindingsPerService(resultSet.getInt(7));
                publisher.setMaxTModels(resultSet.getInt(8));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void delete(String publisherID, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, publisherID);
            if (log.isDebugEnabled()) {
                log.debug("delete from " + tablePrefix + "PUBLISHER table:\n\n\t" + deleteSQL + "\n\t PUBLISHER_ID=" + "\n");
            }
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void update(Publisher publisher, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(updateSQL);
            statement.setString(1, publisher.getName());
            statement.setString(2, publisher.getEmailAddress());
            statement.setString(3, String.valueOf(publisher.isAdmin()));
            statement.setString(4, String.valueOf(publisher.isEnabled()));
            statement.setInt(5, publisher.getMaxBusinesses());
            statement.setInt(6, publisher.getMaxServicesPerBusiness());
            statement.setInt(7, publisher.getMaxBindingsPerService());
            statement.setInt(8, publisher.getMaxTModels());
            statement.setString(9, publisher.getPublisherID());
            if (log.isDebugEnabled()) {
                log.debug("update " + tablePrefix + "PUBLISHER table:\n\n\t" + updateSQL + "\n\t PUBLISHER_NAME=" + publisher.getName() + "\n\t EMAIL_ADDRESS=" + publisher.getEmailAddress() + "\n\t IS_ADMIN=" + publisher.isAdmin() + "\n\t IS_ENABLED=" + publisher.isEnabled() + "\n\t MAX_BUSINESSES=" + publisher.getMaxBusinesses() + "\n\t MAX_SERVICES_PER_BUSINESS=" + publisher.getMaxServicesPerBusiness() + "\n\t MAX_BINDINGS_PER_SERVICE=" + publisher.getMaxBindingsPerService() + "\n\t MAX_TMODELS=" + publisher.getMaxTModels() + "\n\t PUBLISHER_ID=" + publisher.getPublisherID() + "\n");
            }
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error(sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("PUBLISHER (");
        sql.append("PUBLISHER_ID,");
        sql.append("PUBLISHER_NAME,");
        sql.append("EMAIL_ADDRESS,");
        sql.append("IS_ADMIN, ");
        sql.append("IS_ENABLED), ");
        sql.append("MAX_BUSINESSES), ");
        sql.append("MAX_SERVICES_PER_BUSINESS), ");
        sql.append("MAX_BINDINGS_PER_SERVICE), ");
        sql.append("MAX_TMODELS) ");
        sql.append("VALUES (?,?,?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("PUBLISHER_NAME,");
        sql.append("EMAIL_ADDRESS,");
        sql.append("IS_ADMIN,");
        sql.append("IS_ENABLED,");
        sql.append("MAX_BUSINESSES,");
        sql.append("MAX_SERVICES_PER_BUSINESS,");
        sql.append("MAX_BINDINGS_PER_SERVICE,");
        sql.append("MAX_TMODELS ");
        sql.append("FROM ").append(tablePrefix).append("PUBLISHER ");
        sql.append("WHERE PUBLISHER_ID=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("DELETE FROM ").append(tablePrefix).append("PUBLISHER ");
        sql.append("WHERE PUBLISHER_ID=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE ").append(tablePrefix).append("PUBLISHER ");
        sql.append("SET PUBLISHER_NAME=?,");
        sql.append("EMAIL_ADDRESS=?,");
        sql.append("IS_ADMIN=?,");
        sql.append("IS_ENABLED=?,");
        sql.append("MAX_BUSINESSES=?,");
        sql.append("MAX_SERVICES_PER_BUSINESS=?,");
        sql.append("MAX_BINDINGS_PER_SERVICE=?,");
        sql.append("MAX_TMODELS=? ");
        sql.append("WHERE PUBLISHER_ID=?");
        updateSQL = sql.toString();
    }
}

