/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AddPublisherAssertions;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeletePublisherAssertions;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.request.SaveBusiness;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.function.AddPublisherAssertionsFunction;
import org.apache.juddi.function.GetAuthTokenFunction;
import org.apache.juddi.function.SaveBusinessFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeletePublisherAssertionsFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$DeletePublisherAssertionsFunction == null ? (class$org$apache$juddi$function$DeletePublisherAssertionsFunction = DeletePublisherAssertionsFunction.class$("org.apache.juddi.function.DeletePublisherAssertionsFunction")) : class$org$apache$juddi$function$DeletePublisherAssertionsFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$DeletePublisherAssertionsFunction;

    public DeletePublisherAssertionsFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeletePublisherAssertions request = (DeletePublisherAssertions)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector assertionVector = request.getPublisherAssertionVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (int i = 0; i < assertionVector.size(); ++i) {
            }
            dataStore.deleteAssertions(publisherID, assertionVector);
            dataStore.commit();
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken authTokenRequest = new GetAuthToken("sviens", "password");
            GetAuthTokenFunction authTokenService = new GetAuthTokenFunction(reg);
            AuthToken authToken = (AuthToken)authTokenService.execute(authTokenRequest);
            String authInfo = authToken.getAuthInfo().getValue();
            BusinessEntity business1 = new BusinessEntity();
            business1.addName(new Name("Blockbuster", "en"));
            BusinessEntity business2 = new BusinessEntity();
            business2.addName(new Name("Moonlighting", "en"));
            Vector<BusinessEntity> businessVector = new Vector<BusinessEntity>(2);
            businessVector.addElement(business1);
            businessVector.addElement(business2);
            SaveBusiness sbReq = new SaveBusiness();
            sbReq.setAuthInfo(new AuthInfo(authInfo));
            sbReq.setBusinessEntityVector(businessVector);
            BusinessDetail detail = (BusinessDetail)new SaveBusinessFunction(reg).execute(sbReq);
            Vector detailVector = detail.getBusinessEntityVector();
            BusinessEntity b1 = (BusinessEntity)detailVector.elementAt(0);
            BusinessEntity b2 = (BusinessEntity)detailVector.elementAt(1);
            String fromKey = b1.getBusinessKey();
            String toKey = b2.getBusinessKey();
            KeyedReference keyedReference = new KeyedReference("Partner Company", "peer-peer");
            keyedReference.setTModelKey("UUID:807A2C6A-EE22-470D-ADC7-E0424A337C03");
            PublisherAssertion assertion = new PublisherAssertion(fromKey, toKey, keyedReference);
            Vector<PublisherAssertion> assertionVector = new Vector<PublisherAssertion>();
            assertionVector.addElement(assertion);
            AddPublisherAssertions apaReq = new AddPublisherAssertions();
            apaReq.setAuthInfo(new AuthInfo(authInfo));
            apaReq.setPublisherAssertionVector(assertionVector);
            DispositionReport dspRpt1 = (DispositionReport)new AddPublisherAssertionsFunction(reg).execute(apaReq);
            System.out.println("errno: " + dspRpt1.toString());
            DispositionReport dspRpt2 = (DispositionReport)new AddPublisherAssertionsFunction(reg).execute(apaReq);
            System.out.println("errno: " + dspRpt2.toString());
            DeletePublisherAssertions dpaReq = new DeletePublisherAssertions();
            dpaReq.setAuthInfo(new AuthInfo(authInfo));
            dpaReq.setPublisherAssertionVector(assertionVector);
            DispositionReport response = (DispositionReport)new DeletePublisherAssertionsFunction(reg).execute(dpaReq);
            System.out.println("errno: " + response.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

