/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.datatype.response.ServiceList;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ServiceListHandler
extends AbstractHandler {
    public static final String TAG_NAME = "serviceList";
    private HandlerMaker maker = null;

    protected ServiceListHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        ServiceList obj = new ServiceList();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "serviceInfos")).size() > 0) {
            handler = this.maker.lookup("serviceInfos");
            obj.setServiceInfos((ServiceInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        ServiceInfos infos;
        ServiceList list = (ServiceList)object;
        String generic = list.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        String operator = list.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = list.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((infos = list.getServiceInfos()) != null) {
            handler = this.maker.lookup("serviceInfos");
            handler.marshal(infos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

