/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.BusyException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.registry.RegistryServlet;
import org.apache.juddi.util.Config;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractService
extends HttpServlet {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$registry$AbstractService == null ? (class$org$apache$juddi$registry$AbstractService = AbstractService.class$("org.apache.juddi.registry.AbstractService")) : class$org$apache$juddi$registry$AbstractService);
    private static DocumentBuilder docBuilder = null;
    static /* synthetic */ Class class$org$apache$juddi$registry$AbstractService;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setHeader("Allow", "POST");
        res.sendError(405, "Use of the HTTP request method 'GET' is not allowed by UDDI specification.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/xml; charset=utf-8");
        SOAPMessage soapReq = null;
        SOAPMessage soapRes = null;
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            soapReq = msgFactory.createMessage(null, req.getInputStream());
            soapRes = msgFactory.createMessage();
            SOAPBody soapReqBody = soapReq.getSOAPBody();
            Node uddiReq = null;
            Iterator itrChildElements = soapReqBody.getChildElements();
            while (itrChildElements.hasNext()) {
                Object obj = itrChildElements.next();
                if (!(obj instanceof Element)) continue;
                uddiReq = (Element)obj;
                break;
            }
            if (uddiReq == null) {
                throw new FatalErrorException("A UDDI request was not found in the SOAP message.");
            }
            String operation = uddiReq.getLocalName();
            if (operation == null || operation.trim().length() == 0) {
                throw new FatalErrorException("The UDDI service operation could not be identified.");
            }
            String version2 = uddiReq.getAttribute("generic");
            if (version2 == null) {
                throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + operation + " (The " + "'generic' attribute must be present)");
            }
            this.validateRequest(operation, version2, (Element)uddiReq);
            HandlerMaker maker = HandlerMaker.getInstance();
            AbstractHandler requestHandler = maker.lookup(operation);
            if (requestHandler == null) {
                throw new UnsupportedException("The UDDI service operation specified is unknown or unsupported: " + operation);
            }
            RegistryObject uddiReqObj = requestHandler.unmarshal((Element)uddiReq);
            RegistryObject uddiResObj = null;
            RegistryEngine registry = RegistryServlet.getRegistry();
            if (registry == null || !registry.isAvailable()) {
                throw new BusyException("The Registry is currently unavailable.");
            }
            uddiResObj = registry.execute(uddiReqObj);
            AbstractHandler responseHandler = maker.lookup(uddiResObj.getClass().getName());
            if (responseHandler == null) {
                throw new FatalErrorException("The response object type is unknown: " + uddiResObj.getClass().getName());
            }
            DocumentBuilder docBuilder = this.getDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element element = document.createElement("temp");
            responseHandler.marshal(uddiResObj, element);
            document.appendChild(element.getFirstChild());
            soapRes.getSOAPBody().addDocument(document);
        }
        catch (Exception ex) {
            String faultCode = null;
            String faultString = null;
            String faultActor = null;
            String errno = null;
            String errCode = null;
            String errText = null;
            if (ex instanceof RegistryException) {
                log.error(ex.getMessage());
                RegistryException rex = (RegistryException)ex;
                faultCode = rex.getFaultCode();
                faultString = rex.getFaultString();
                faultActor = rex.getFaultActor();
                DispositionReport dispRpt = rex.getDispositionReport();
                if (dispRpt != null) {
                    Result result = null;
                    ErrInfo errInfo = null;
                    Vector results = dispRpt.getResultVector();
                    if (results != null && !results.isEmpty()) {
                        result = (Result)results.elementAt(0);
                    }
                    if (result != null) {
                        errno = String.valueOf(result.getErrno());
                        errInfo = result.getErrInfo();
                        if (errInfo != null) {
                            errCode = errInfo.getErrCode();
                            errText = errInfo.getErrMsg();
                        }
                    }
                }
            } else if (ex instanceof SOAPException) {
                log.error(ex.getMessage());
                faultCode = "Client";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode(10500);
                errText = Result.lookupErrText(10500) + " " + ex.getMessage();
            } else {
                log.error(ex.getMessage(), ex);
                faultCode = "Server";
                faultString = ex.getMessage();
                faultActor = null;
                errno = String.valueOf(10500);
                errCode = Result.lookupErrCode(10500);
                errText = Result.lookupErrText(10500) + " An internal UDDI server error has " + "occurred. Please report this error " + "to the UDDI server administrator.";
            }
            try {
                SOAPBody soapResBody = soapRes.getSOAPBody();
                SOAPFault soapFault = soapResBody.addFault();
                soapFault.setFaultCode(faultCode);
                soapFault.setFaultString(faultString);
                soapFault.setFaultActor(faultActor);
                Detail faultDetail = soapFault.addDetail();
                SOAPElement dispRpt = faultDetail.addChildElement("dispositionReport", "", "urn:uddi-org:api_v2");
                dispRpt.setAttribute("generic", "2.0");
                dispRpt.setAttribute("operator", Config.getOperator());
                SOAPElement result = dispRpt.addChildElement("result");
                result.setAttribute("errno", errno);
                SOAPElement errInfo = result.addChildElement("errInfo");
                errInfo.setAttribute("errCode", errCode);
                errInfo.setValue(errText);
            }
            catch (Exception e) {
                log.error("A serious error has occured while assembling the SOAP Fault.", e);
            }
        }
        finally {
            try {
                soapRes.setProperty("javax.xml.soap.write-xml-declaration", "true");
                soapRes.writeTo(res.getOutputStream());
            }
            catch (SOAPException sex) {
                log.error(sex);
            }
        }
    }

    public abstract void validateRequest(String var1, String var2, Element var3) throws RegistryException;

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

