/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.juddi.error.FatalErrorException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.registry.AbstractService;
import org.w3c.dom.Element;

public class InquiryService
extends AbstractService {
    private TreeSet operations = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.operations = new TreeSet();
        this.operations.add("find_business");
        this.operations.add("find_service");
        this.operations.add("find_binding");
        this.operations.add("find_tmodel");
        this.operations.add("find_relatedbusinesses");
        this.operations.add("get_businessdetail");
        this.operations.add("get_businessdetailext");
        this.operations.add("get_servicedetail");
        this.operations.add("get_bindingdetail");
        this.operations.add("get_tmodeldetail");
    }

    public void validateRequest(String operation, String version2, Element uddiReq) throws RegistryException {
        if (version2 == null) {
            throw new FatalErrorException("A UDDI generic attribute value was not found for UDDI request: " + operation + " (The " + "'generic' attribute must be present)");
        }
        if (!version2.equals("2.0")) {
            throw new UnsupportedException("Only UDDI v2 requests are currently supported. The generic attribute value received was: " + version2);
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new FatalErrorException("The UDDI service operation could not be identified.");
        }
        if (!this.operations.contains(operation.toLowerCase())) {
            throw new UnsupportedException("The operation " + operation + " is not " + "supported by the UDDI version 2 Inquiry API.");
        }
    }
}

