/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config
extends Properties {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$util$Config == null ? (class$org$apache$juddi$util$Config = Config.class$("org.apache.juddi.util.Config")) : class$org$apache$juddi$util$Config);
    static Config config;
    static /* synthetic */ Class class$org$apache$juddi$util$Config;

    private Config() {
    }

    public static void addProperties(Properties props) {
        if (config == null) {
            config = Config.createConfig();
        }
        config.putAll((Map<?, ?>)props);
    }

    public static Properties getProperties() {
        if (config == null) {
            config = Config.createConfig();
        }
        return config;
    }

    public static String getOperator() {
        return Config.getStringProperty("juddi.operatorName", "Apache.org");
    }

    public static String getDiscoveryURL() {
        return Config.getStringProperty("juddi.discoveryURL", "http://localhost:8080/juddi/uddiget.jsp?");
    }

    public static int getMaxNameLengthAllowed() {
        return Config.getIntProperty("juddi.maxNameLengthAllowed", 255);
    }

    public static int getMaxNameElementsAllowed() {
        return Config.getIntProperty("juddi.maxNameElementsAllowed", 5);
    }

    public static int getMaxBusinessesPerPublisher() {
        return Config.getIntProperty("juddi.maxBusinessesPerPublisher", -1);
    }

    public static int getMaxServicesPerBusiness() {
        return Config.getIntProperty("juddi.maxServicesPerBusiness", -1);
    }

    public static int getMaxBindingsPerService() {
        return Config.getIntProperty("juddi.maxBindingsPerService", -1);
    }

    public static int getMaxTModelsPerPublisher() {
        return Config.getIntProperty("juddi.maxTModelsPerPublisher", -1);
    }

    public static String getStringProperty(String key, String defaultValue) {
        String stringVal = defaultValue;
        String propValue = Config.getStringProperty(key);
        if (propValue != null) {
            stringVal = propValue;
        }
        return stringVal;
    }

    public static int getIntProperty(String key, int defaultValue) {
        int intVal = defaultValue;
        String propValue = Config.getStringProperty(key);
        if (propValue != null) {
            intVal = Integer.parseInt(propValue);
        }
        return intVal;
    }

    public static long getLongProperty(String key, long defaultValue) {
        long longVal = defaultValue;
        String propValue = Config.getStringProperty(key);
        if (propValue != null) {
            longVal = Long.parseLong(propValue);
        }
        return longVal;
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean boolVal = defaultValue;
        String propValue = Config.getStringProperty(key);
        if (propValue != null) {
            if (propValue.equalsIgnoreCase("true")) {
                boolVal = true;
            } else if (propValue.equalsIgnoreCase("false")) {
                boolVal = false;
            }
        }
        return boolVal;
    }

    public static URL getURLProperty(String key, URL defaultValue) {
        URL urlVal = defaultValue;
        String propValue = Config.getStringProperty(key);
        if (propValue != null) {
            try {
                urlVal = new URL(propValue);
            }
            catch (MalformedURLException muex) {
                log.error("The " + key + " property value is invalid: " + propValue, muex);
            }
        }
        return urlVal;
    }

    public static String getStringProperty(String key) {
        if (config == null) {
            config = Config.createConfig();
        }
        if (config == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        return config.getProperty(key);
    }

    public static void setStringProperty(String name, String value) {
        if (config == null) {
            config = Config.createConfig();
        }
        if (config == null) {
            return;
        }
        if (name == null) {
            return;
        }
        if (value == null) {
            config.remove(name);
        } else {
            config.setProperty(name, value);
        }
    }

    private static synchronized Config createConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        Enumeration<Object> propKeys = this.keys();
        while (propKeys.hasMoreElements()) {
            String propName = (String)propKeys.nextElement();
            String propValue = this.getProperty(propName);
            buff.append(propName.trim());
            buff.append("=");
            buff.append(propValue.trim());
            buff.append("\n");
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        Properties sysProps = null;
        TreeSet<Object> sortedPropsSet = null;
        sysProps = Config.getProperties();
        sortedPropsSet = new TreeSet<Object>(sysProps.keySet());
        Iterator keys = sortedPropsSet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            System.out.println(key + ": " + sysProps.getProperty(key));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

