/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.core.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopFilterFactory
extends BaseTokenFilterFactory {
    private Set stopWords = StopFilter.makeStopSet(StopAnalyzer.ENGLISH_STOP_WORDS);
    private boolean ignoreCase;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String stopWordFile = args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (stopWordFile != null) {
            try {
                List<String> wlist = Config.getLines(stopWordFile);
                this.stopWords = StopFilter.makeStopSet(wlist.toArray(new String[0]), this.ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new StopFilter(input, this.stopWords, this.ignoreCase);
    }
}

