/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.NamedList;
import org.xml.sax.SAXException;

public class SolrConfig {
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    public static Config config;
    public static final Collection<Throwable> severeErrors;

    public static synchronized void initConfig(String file) throws ParserConfigurationException, IOException, SAXException {
        InputStream is = Config.openResource(file);
        config = new Config(file, is, "/config/");
        is.close();
        Config.log.info("Loaded SolrConfig: " + file);
    }

    public static SolrQueryRequest getPingQueryRequest(SolrCore core) {
        String urlSnippet = config.get("admin/pingQuery", "").trim();
        StringTokenizer qtokens = new StringTokenizer(urlSnippet, "&");
        NamedList<String> params = new NamedList<String>();
        while (qtokens.hasMoreTokens()) {
            String tok = qtokens.nextToken();
            String[] split = tok.split("=", 2);
            params.add(split[0], split[1]);
        }
        return new LocalSolrQueryRequest(core, params);
    }

    static {
        severeErrors = new HashSet<Throwable>();
        try {
            SolrConfig.initConfig(DEFAULT_CONF_FILE);
        }
        catch (Exception ee) {
            severeErrors.add(ee);
            throw new RuntimeException("Error in solrconfig.xml", ee);
        }
    }
}

