/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Writer;

public class XML {
    private static final String[] chardata_escapes = new String[]{"#0;", "#1;", "#2;", "#3;", "#4;", "#5;", "#6;", "#7;", "#8;", null, null, "#11;", "#12;", null, "#14;", "#15;", "#16;", "#17;", "#18;", "#19;", "#20;", "#21;", "#22;", "#23;", "#24;", "#25;", "#26;", "#27;", "#28;", "#29;", "#30;", "#31;", null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;"};
    private static final String[] attribute_escapes = new String[]{"#0;", "#1;", "#2;", "#3;", "#4;", "#5;", "#6;", "#7;", "#8;", null, null, "#11;", "#12;", null, "#14;", "#15;", "#16;", "#17;", "#18;", "#19;", "#20;", "#21;", "#22;", "#23;", "#24;", "#25;", "#26;", "#27;", "#28;", "#29;", "#30;", "#31;", null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;"};

    public static void escapeCharData(String str, Writer out) throws IOException {
        XML.escape(str, out, chardata_escapes);
    }

    public static void escapeAttributeValue(String str, Writer out) throws IOException {
        XML.escape(str, out, attribute_escapes);
    }

    public static final void writeXML(Writer out, String tag, String val) throws IOException {
        out.write(60);
        out.write(tag);
        if (val == null) {
            out.write("/>");
        } else {
            out.write(62);
            XML.escapeCharData(val, out);
            out.write("</");
            out.write(tag);
            out.write(62);
        }
    }

    public static final void writeUnescapedXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        out.write(60);
        out.write(tag);
        for (int i = 0; i < attrs.length; ++i) {
            out.write(32);
            out.write(attrs[i++].toString());
            out.write("=\"");
            out.write(attrs[i].toString());
            out.write("\"");
        }
        if (val == null) {
            out.write("/>");
        } else {
            out.write(62);
            out.write(val);
            out.write("</");
            out.write(tag);
            out.write(62);
        }
    }

    public static final void writeXML(Writer out, String tag, String val, Object ... attrs) throws IOException {
        out.write(60);
        out.write(tag);
        for (int i = 0; i < attrs.length; ++i) {
            out.write(32);
            out.write(attrs[i++].toString());
            out.write("=\"");
            XML.escapeAttributeValue(attrs[i].toString(), out);
            out.write("\"");
        }
        if (val == null) {
            out.write("/>");
        } else {
            out.write(62);
            XML.escapeCharData(val, out);
            out.write("</");
            out.write(tag);
            out.write(62);
        }
    }

    private static void escape(String str, Writer out, String[] escapes) throws IOException {
        int start;
        for (int i = start = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String subst = null;
            if (ch < escapes.length) {
                subst = escapes[ch];
            }
            if (subst == null) continue;
            if (start < i) {
                out.write(str.substring(start, i));
            }
            out.write(subst);
            start = i + 1;
        }
        if (start == 0) {
            out.write(str);
        } else if (start < str.length()) {
            out.write(str.substring(start));
        }
    }
}

