/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.scout.registry.IRegistry;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.uddi.AssertionStatusReport;
import org.apache.ws.scout.uddi.AssertionStatusReportDocument;
import org.apache.ws.scout.uddi.AuthToken;
import org.apache.ws.scout.uddi.AuthTokenDocument;
import org.apache.ws.scout.uddi.BindingDetail;
import org.apache.ws.scout.uddi.BindingDetailDocument;
import org.apache.ws.scout.uddi.BindingTemplate;
import org.apache.ws.scout.uddi.BusinessDetail;
import org.apache.ws.scout.uddi.BusinessDetailDocument;
import org.apache.ws.scout.uddi.BusinessEntity;
import org.apache.ws.scout.uddi.BusinessList;
import org.apache.ws.scout.uddi.BusinessListDocument;
import org.apache.ws.scout.uddi.BusinessService;
import org.apache.ws.scout.uddi.CategoryBag;
import org.apache.ws.scout.uddi.DeleteBinding;
import org.apache.ws.scout.uddi.DeleteBindingDocument;
import org.apache.ws.scout.uddi.DeleteBusiness;
import org.apache.ws.scout.uddi.DeleteBusinessDocument;
import org.apache.ws.scout.uddi.DeletePublisherAssertions;
import org.apache.ws.scout.uddi.DeletePublisherAssertionsDocument;
import org.apache.ws.scout.uddi.DeleteService;
import org.apache.ws.scout.uddi.DeleteServiceDocument;
import org.apache.ws.scout.uddi.DeleteTModel;
import org.apache.ws.scout.uddi.DeleteTModelDocument;
import org.apache.ws.scout.uddi.DiscoveryURLs;
import org.apache.ws.scout.uddi.DispositionReport;
import org.apache.ws.scout.uddi.DispositionReportDocument;
import org.apache.ws.scout.uddi.FindBinding;
import org.apache.ws.scout.uddi.FindBindingDocument;
import org.apache.ws.scout.uddi.FindBusiness;
import org.apache.ws.scout.uddi.FindBusinessDocument;
import org.apache.ws.scout.uddi.FindQualifiers;
import org.apache.ws.scout.uddi.FindService;
import org.apache.ws.scout.uddi.FindServiceDocument;
import org.apache.ws.scout.uddi.FindTModel;
import org.apache.ws.scout.uddi.FindTModelDocument;
import org.apache.ws.scout.uddi.GetAssertionStatusReport;
import org.apache.ws.scout.uddi.GetAssertionStatusReportDocument;
import org.apache.ws.scout.uddi.GetAuthToken;
import org.apache.ws.scout.uddi.GetAuthTokenDocument;
import org.apache.ws.scout.uddi.GetBusinessDetail;
import org.apache.ws.scout.uddi.GetBusinessDetailDocument;
import org.apache.ws.scout.uddi.GetPublisherAssertions;
import org.apache.ws.scout.uddi.GetPublisherAssertionsDocument;
import org.apache.ws.scout.uddi.GetServiceDetail;
import org.apache.ws.scout.uddi.GetServiceDetailDocument;
import org.apache.ws.scout.uddi.GetTModelDetail;
import org.apache.ws.scout.uddi.GetTModelDetailDocument;
import org.apache.ws.scout.uddi.IdentifierBag;
import org.apache.ws.scout.uddi.Name;
import org.apache.ws.scout.uddi.PublisherAssertion;
import org.apache.ws.scout.uddi.PublisherAssertions;
import org.apache.ws.scout.uddi.PublisherAssertionsDocument;
import org.apache.ws.scout.uddi.SaveBinding;
import org.apache.ws.scout.uddi.SaveBindingDocument;
import org.apache.ws.scout.uddi.SaveBusiness;
import org.apache.ws.scout.uddi.SaveBusinessDocument;
import org.apache.ws.scout.uddi.SaveService;
import org.apache.ws.scout.uddi.SaveServiceDocument;
import org.apache.ws.scout.uddi.SaveTModel;
import org.apache.ws.scout.uddi.SaveTModelDocument;
import org.apache.ws.scout.uddi.ServiceDetail;
import org.apache.ws.scout.uddi.ServiceDetailDocument;
import org.apache.ws.scout.uddi.ServiceList;
import org.apache.ws.scout.uddi.ServiceListDocument;
import org.apache.ws.scout.uddi.SetPublisherAssertions;
import org.apache.ws.scout.uddi.SetPublisherAssertionsDocument;
import org.apache.ws.scout.uddi.TModel;
import org.apache.ws.scout.uddi.TModelBag;
import org.apache.ws.scout.uddi.TModelDetail;
import org.apache.ws.scout.uddi.TModelDetailDocument;
import org.apache.ws.scout.uddi.TModelList;
import org.apache.ws.scout.uddi.TModelListDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegistryImpl
implements IRegistry {
    public static final String INQUIRY_ENDPOINT_PROPERTY_NAME = "scout.proxy.inquiryURL";
    public static final String PUBLISH_ENDPOINT_PROPERTY_NAME = "scout.proxy.publishURL";
    public static final String ADMIN_ENDPOINT_PROPERTY_NAME = "scout.proxy.adminURL";
    public static final String TRANSPORT_CLASS_PROPERTY_NAME = "scout.proxy.transportClass";
    public static final String SECURITY_PROVIDER_PROPERTY_NAME = "scout.proxy.securityProvider";
    public static final String PROTOCOL_HANDLER_PROPERTY_NAME = "scout.proxy.protocolHandler";
    public static final String UDDI_VERSION_PROPERTY_NAME = "scout.proxy.uddiVersion";
    public static final String UDDI_NAMESPACE_PROPERTY_NAME = "scout.proxy.uddiNamespace";
    public static final String DEFAULT_INQUIRY_ENDPOINT = "http://localhost/juddi/inquiry";
    public static final String DEFAULT_PUBLISH_ENDPOINT = "http://localhost/juddi/publish";
    public static final String DEFAULT_ADMIN_ENDPOINT = "http://localhost/juddi/admin";
    public static final String DEFAULT_TRANSPORT_CLASS = "org.apache.ws.scout.transport.AxisTransport";
    public static final String DEFAULT_SECURITY_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String DEFAULT_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String DEFAULT_UDDI_VERSION = "2.0";
    public static final String DEFAULT_UDDI_NAMESPACE = "urn:uddi-org:api_v2";
    private URI adminURI;
    private URI inquiryURI;
    private URI publishURI;
    private Transport transport;
    private String securityProvider;
    private String protocolHandler;
    private String uddiVersion;
    private String uddiNamespace;

    public RegistryImpl(Properties props) {
        this.init(props);
    }

    private void init(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        try {
            String iURL = props.getProperty(INQUIRY_ENDPOINT_PROPERTY_NAME);
            if (iURL != null) {
                this.setInquiryURI(new URI(iURL));
            } else {
                this.setInquiryURI(new URI(DEFAULT_INQUIRY_ENDPOINT));
            }
            String pURL = props.getProperty(PUBLISH_ENDPOINT_PROPERTY_NAME);
            if (pURL != null) {
                this.setPublishURI(new URI(pURL));
            } else {
                this.setPublishURI(new URI(DEFAULT_PUBLISH_ENDPOINT));
            }
            String aURL = props.getProperty(ADMIN_ENDPOINT_PROPERTY_NAME);
            if (aURL != null) {
                this.setAdminURI(new URI(aURL));
            } else {
                this.setAdminURI(new URI(DEFAULT_ADMIN_ENDPOINT));
            }
        }
        catch (URISyntaxException muex) {
            muex.printStackTrace();
        }
        String secProvider = props.getProperty(SECURITY_PROVIDER_PROPERTY_NAME);
        if (secProvider != null) {
            this.setSecurityProvider(secProvider);
        } else {
            this.setSecurityProvider(DEFAULT_SECURITY_PROVIDER);
        }
        String protoHandler = props.getProperty(PROTOCOL_HANDLER_PROPERTY_NAME);
        if (protoHandler != null) {
            this.setProtocolHandler(protoHandler);
        } else {
            this.setProtocolHandler(DEFAULT_PROTOCOL_HANDLER);
        }
        String uddiVer = props.getProperty(UDDI_VERSION_PROPERTY_NAME);
        if (uddiVer != null) {
            this.setUddiVersion(uddiVer);
        } else {
            this.setUddiVersion(DEFAULT_UDDI_VERSION);
        }
        String uddiNS = props.getProperty(UDDI_NAMESPACE_PROPERTY_NAME);
        if (uddiNS != null) {
            this.setUddiNamespace(uddiNS);
        } else {
            this.setUddiNamespace(DEFAULT_UDDI_NAMESPACE);
        }
        String transClass = props.getProperty(TRANSPORT_CLASS_PROPERTY_NAME);
        if (transClass != null) {
            this.setTransport(this.getTransport(transClass));
        } else {
            this.setTransport(this.getTransport(DEFAULT_TRANSPORT_CLASS));
        }
    }

    public String execute(String uddiRequest, String urltype) throws RegistryException {
        URI endPointURL = null;
        endPointURL = urltype.equalsIgnoreCase("INQUIRY") ? this.getInquiryURI() : this.getPublishURI();
        return this.transport.send(uddiRequest, endPointURL);
    }

    public XmlObject execute(XmlObject uddiRequest, URI endPointURI) throws RegistryException {
        String responseName;
        Document doc;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(uddiRequest.newInputStream());
        }
        catch (SAXException saxe) {
            throw new RegistryException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException(pce);
        }
        catch (IOException ioe) {
            throw new RegistryException(ioe);
        }
        Element request = doc.getDocumentElement();
        request.setAttribute("generic", this.getUddiVersion());
        request.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getUddiNamespace());
        Element response = this.transport.send(request, endPointURI);
        if (response.getNamespaceURI() == null) {
            response.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getUddiNamespace());
        }
        if ((responseName = response.getLocalName()) == null) {
            throw new RegistryException("Unsupported response from registry. A value was not present.");
        }
        XmlObject uddiResponse = null;
        try {
            uddiResponse = XmlObject.Factory.parse(response);
            XmlCursor cursor = uddiResponse.newCursor();
            cursor.toNextToken();
            if ("".equals(cursor.getName().getNamespaceURI())) {
                cursor.setName(new QName(this.getUddiNamespace(), cursor.getName().getLocalPart()));
                while (cursor.hasNextToken()) {
                    cursor.toNextToken();
                    if (!cursor.isStart() || !"".equals(cursor.getName().getNamespaceURI())) continue;
                    cursor.setName(new QName(this.getUddiNamespace(), cursor.getName().getLocalPart()));
                }
                cursor.dispose();
            }
        }
        catch (XmlException xmle) {
            throw new RegistryException(xmle);
        }
        if (responseName.toLowerCase().equals("fault")) {
            NodeList nodeList = null;
            String fCode = null;
            nodeList = response.getElementsByTagName("faultcode");
            if (nodeList.getLength() > 0) {
                fCode = nodeList.item(0).getNodeValue();
            }
            String fString = null;
            nodeList = response.getElementsByTagName("faultstring");
            if (nodeList.getLength() > 0) {
                fString = nodeList.item(0).getNodeValue();
            }
            String fActor = null;
            nodeList = response.getElementsByTagName("faultactor");
            if (nodeList.getLength() > 0) {
                fActor = nodeList.item(0).getNodeValue();
            }
            DispositionReport dispRpt = null;
            nodeList = response.getElementsByTagName("detail");
            if (nodeList.getLength() > 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("dispositionReport")).getLength() > 0) {
                XmlObject dispRptObj = null;
                try {
                    dispRptObj = XmlObject.Factory.parse((Element)nodeList.item(0));
                }
                catch (XmlException xmle) {
                    throw new RegistryException(xmle);
                }
                XmlObject o = dispRptObj.changeType(DispositionReportDocument.type);
                dispRpt = ((DispositionReportDocument)o).getDispositionReport();
            }
            RegistryException e = new RegistryException(fCode, fString, fActor, dispRpt);
            System.err.println("SOAP message:");
            System.err.println(uddiResponse.xmlText());
            throw e;
        }
        return uddiResponse;
    }

    public URI getAdminURI() {
        return this.adminURI;
    }

    public void setAdminURI(URI url) {
        this.adminURI = url;
    }

    public URI getInquiryURI() {
        return this.inquiryURI;
    }

    public void setInquiryURI(URI inquiryURI) {
        this.inquiryURI = inquiryURI;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public URI getPublishURI() {
        return this.publishURI;
    }

    public void setPublishURI(URI publishURI) {
        this.publishURI = publishURI;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getUddiNamespace() {
        return this.uddiNamespace;
    }

    public void setUddiNamespace(String uddiNS) {
        this.uddiNamespace = uddiNS;
    }

    public String getUddiVersion() {
        return this.uddiVersion;
    }

    public void setUddiVersion(String uddiVersion) {
        this.uddiVersion = uddiVersion;
    }

    public DispositionReport deleteBinding(String authInfo, String[] bindingKeyArray) throws RegistryException {
        DeleteBindingDocument doc = DeleteBindingDocument.Factory.newInstance();
        DeleteBinding request = doc.addNewDeleteBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingKeyArray != null) {
            request.setBindingKeyArray(bindingKeyArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(DispositionReportDocument.type);
        DispositionReport dr = ((DispositionReportDocument)o).getDispositionReport();
        return dr;
    }

    public DispositionReport deleteBusiness(String authInfo, String[] businessKeyArray) throws RegistryException {
        DeleteBusinessDocument doc = DeleteBusinessDocument.Factory.newInstance();
        DeleteBusiness request = doc.addNewDeleteBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessKeyArray != null) {
            request.setBusinessKeyArray(businessKeyArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(DispositionReportDocument.type);
        DispositionReport dr = ((DispositionReportDocument)o).getDispositionReport();
        return dr;
    }

    public DispositionReport deletePublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryException {
        DeletePublisherAssertionsDocument doc = DeletePublisherAssertionsDocument.Factory.newInstance();
        DeletePublisherAssertions request = doc.addNewDeletePublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.setPublisherAssertionArray(assertionArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(DispositionReportDocument.type);
        DispositionReport dr = ((DispositionReportDocument)o).getDispositionReport();
        return dr;
    }

    public DispositionReport deleteService(String authInfo, String[] serviceKeyArray) throws RegistryException {
        DeleteServiceDocument doc = DeleteServiceDocument.Factory.newInstance();
        DeleteService request = doc.addNewDeleteService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceKeyArray != null) {
            request.setServiceKeyArray(serviceKeyArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(DispositionReportDocument.type);
        DispositionReport dr = ((DispositionReportDocument)o).getDispositionReport();
        return dr;
    }

    public DispositionReport deleteTModel(String authInfo, String[] tModelKeyArray) throws RegistryException {
        DeleteTModelDocument doc = DeleteTModelDocument.Factory.newInstance();
        DeleteTModel request = doc.addNewDeleteTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelKeyArray != null) {
            request.setTModelKeyArray(tModelKeyArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(DispositionReportDocument.type);
        DispositionReport dr = ((DispositionReportDocument)o).getDispositionReport();
        return dr;
    }

    public BusinessList findBusiness(Name[] nameArray, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBusinessDocument doc = FindBusinessDocument.Factory.newInstance();
        FindBusiness request = doc.addNewFindBusiness();
        if (nameArray != null) {
            request.setNameArray(nameArray);
        }
        if (discoveryURLs != null) {
            request.setDiscoveryURLs(discoveryURLs);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(BusinessListDocument.type);
        BusinessList bl = ((BusinessListDocument)o).getBusinessList();
        return bl;
    }

    public BindingDetail findBinding(String serviceKey, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBindingDocument doc = FindBindingDocument.Factory.newInstance();
        FindBinding request = doc.addNewFindBinding();
        if (serviceKey != null) {
            request.setServiceKey(serviceKey);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(BindingDetailDocument.type);
        BindingDetail bd = ((BindingDetailDocument)o).getBindingDetail();
        return bd;
    }

    public ServiceList findService(String businessKey, Name[] nameArray, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindServiceDocument doc = FindServiceDocument.Factory.newInstance();
        FindService request = doc.addNewFindService();
        if (businessKey != null) {
            request.setBusinessKey(businessKey);
        }
        if (nameArray != null) {
            request.setNameArray(nameArray);
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(ServiceListDocument.type);
        ServiceList sl = ((ServiceListDocument)o).getServiceList();
        return sl;
    }

    public TModelList findTModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindTModelDocument doc = FindTModelDocument.Factory.newInstance();
        FindTModel request = doc.addNewFindTModel();
        Name n = Name.Factory.newInstance();
        if (name != null) {
            n.setStringValue(name);
        }
        request.setName(n);
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(TModelListDocument.type);
        TModelList tml = ((TModelListDocument)o).getTModelList();
        return tml;
    }

    public AssertionStatusReport getAssertionStatusReport(String authInfo, String completionStatus) throws RegistryException {
        GetAssertionStatusReportDocument doc = GetAssertionStatusReportDocument.Factory.newInstance();
        GetAssertionStatusReport request = doc.addNewGetAssertionStatusReport();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (completionStatus != null) {
            request.setCompletionStatus(completionStatus);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(AssertionStatusReportDocument.type);
        AssertionStatusReport asr = ((AssertionStatusReportDocument)o).getAssertionStatusReport();
        return asr;
    }

    public AuthToken getAuthToken(String userID, String cred) throws RegistryException {
        GetAuthTokenDocument doc = GetAuthTokenDocument.Factory.newInstance();
        GetAuthToken request = doc.addNewGetAuthToken();
        if (userID != null) {
            request.setUserID(userID);
        }
        if (cred != null) {
            request.setCred(cred);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(AuthTokenDocument.type);
        AuthToken at = ((AuthTokenDocument)o).getAuthToken();
        return at;
    }

    public BusinessDetail getBusinessDetail(String businessKey) throws RegistryException {
        String[] keys = new String[]{businessKey};
        return this.getBusinessDetail(keys);
    }

    public BusinessDetail getBusinessDetail(String[] businessKeyArray) throws RegistryException {
        GetBusinessDetailDocument doc = GetBusinessDetailDocument.Factory.newInstance();
        GetBusinessDetail request = doc.addNewGetBusinessDetail();
        if (businessKeyArray != null) {
            request.setBusinessKeyArray(businessKeyArray);
        }
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(BusinessDetailDocument.type);
        BusinessDetail bd = ((BusinessDetailDocument)o).getBusinessDetail();
        return bd;
    }

    public PublisherAssertions getPublisherAssertions(String authInfo) throws RegistryException {
        GetPublisherAssertionsDocument doc = GetPublisherAssertionsDocument.Factory.newInstance();
        GetPublisherAssertions request = doc.addNewGetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(PublisherAssertionsDocument.type);
        PublisherAssertions pa = ((PublisherAssertionsDocument)o).getPublisherAssertions();
        return pa;
    }

    public ServiceDetail getServiceDetail(String serviceKey) throws RegistryException {
        String[] keys = new String[]{serviceKey};
        return this.getServiceDetail(keys);
    }

    public ServiceDetail getServiceDetail(String[] serviceKeyArray) throws RegistryException {
        GetServiceDetailDocument doc = GetServiceDetailDocument.Factory.newInstance();
        GetServiceDetail request = doc.addNewGetServiceDetail();
        if (serviceKeyArray != null) {
            request.setServiceKeyArray(serviceKeyArray);
        }
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(ServiceDetailDocument.type);
        ServiceDetail sd = ((ServiceDetailDocument)o).getServiceDetail();
        return sd;
    }

    public TModelDetail getTModelDetail(String tModelKey) throws RegistryException {
        String[] keys = new String[]{tModelKey};
        return this.getTModelDetail(keys);
    }

    public TModelDetail getTModelDetail(String[] tModelKeyArray) throws RegistryException {
        GetTModelDetailDocument doc = GetTModelDetailDocument.Factory.newInstance();
        GetTModelDetail request = doc.addNewGetTModelDetail();
        if (tModelKeyArray != null) {
            request.setTModelKeyArray(tModelKeyArray);
        }
        XmlObject o = this.execute(doc, this.getInquiryURI()).changeType(TModelDetailDocument.type);
        TModelDetail tmd = ((TModelDetailDocument)o).getTModelDetail();
        return tmd;
    }

    public PublisherAssertions setPublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryException {
        SetPublisherAssertionsDocument doc = SetPublisherAssertionsDocument.Factory.newInstance();
        SetPublisherAssertions request = doc.addNewSetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.setPublisherAssertionArray(assertionArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(PublisherAssertionsDocument.type);
        PublisherAssertions pa = ((PublisherAssertionsDocument)o).getPublisherAssertions();
        return pa;
    }

    public BindingDetail saveBinding(String authInfo, BindingTemplate[] bindingArray) throws RegistryException {
        SaveBindingDocument doc = SaveBindingDocument.Factory.newInstance();
        SaveBinding request = doc.addNewSaveBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingArray != null) {
            request.setBindingTemplateArray(bindingArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(BindingDetailDocument.type);
        BindingDetail bd = ((BindingDetailDocument)o).getBindingDetail();
        return bd;
    }

    public BusinessDetail saveBusiness(String authInfo, BusinessEntity[] businessArray) throws RegistryException {
        SaveBusinessDocument doc = SaveBusinessDocument.Factory.newInstance();
        SaveBusiness request = doc.addNewSaveBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessArray != null) {
            request.setBusinessEntityArray(businessArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(BusinessDetailDocument.type);
        BusinessDetail bd = ((BusinessDetailDocument)o).getBusinessDetail();
        return bd;
    }

    public ServiceDetail saveService(String authInfo, BusinessService[] serviceArray) throws RegistryException {
        SaveServiceDocument doc = SaveServiceDocument.Factory.newInstance();
        SaveService request = doc.addNewSaveService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceArray != null) {
            request.setBusinessServiceArray(serviceArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(ServiceDetailDocument.type);
        ServiceDetail sd = ((ServiceDetailDocument)o).getServiceDetail();
        return sd;
    }

    public TModelDetail saveTModel(String authInfo, TModel[] tModelArray) throws RegistryException {
        SaveTModelDocument doc = SaveTModelDocument.Factory.newInstance();
        SaveTModel request = doc.addNewSaveTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelArray != null) {
            request.setTModelArray(tModelArray);
        }
        XmlObject o = this.execute(doc, this.getPublishURI()).changeType(TModelDetailDocument.type);
        TModelDetail tmd = ((TModelDetailDocument)o).getTModelDetail();
        return tmd;
    }

    public Transport getTransport(String className) {
        Transport transport = null;
        Class transportClass = null;
        if (className == null) {
            className = DEFAULT_TRANSPORT_CLASS;
        }
        try {
            transportClass = RegistryImpl.getClassForName(className);
        }
        catch (ClassNotFoundException cnfex) {
            cnfex.printStackTrace();
        }
        try {
            transport = (Transport)transportClass.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return transport;
    }

    public static Class getClassForName(String name) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> clazz = null;
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(name, true, ccl);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == clazz) {
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            try {
                clazz = Class.forName(name, true, scl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return clazz;
    }
}

