/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.transport;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.transport.Transport;
import org.w3c.dom.Element;

public class AxisTransport
implements Transport {
    private static Log log = LogFactory.getLog(AxisTransport.class);

    public Element send(Element request, URI endpointURL) throws RegistryException {
        Service service = null;
        Call call = null;
        Element response = null;
        log.debug("\nRequest message:\n" + XMLUtils.ElementToString(request));
        System.err.println(endpointURL.toString());
        try {
            service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(endpointURL.toURL());
            String requestString = XMLUtils.ElementToString(request);
            SOAPBodyElement body = new SOAPBodyElement(new ByteArrayInputStream(requestString.getBytes("UTF-8")));
            Object[] soapBodies = new Object[]{body};
            Vector result = (Vector)call.invoke(soapBodies);
            response = ((SOAPBodyElement)result.elementAt(0)).getAsDOM();
        }
        catch (AxisFault fault) {
            fault.printStackTrace();
            try {
                Message msg = call.getResponseMessage();
                response = msg.getSOAPEnvelope().getFirstBody().getAsDOM();
            }
            catch (Exception ex) {
                throw new RegistryException(ex);
            }
        }
        catch (Exception ex) {
            throw new RegistryException(ex);
        }
        log.debug("\nResponse message:\n" + XMLUtils.ElementToString(response));
        return response;
    }

    public String send(String request, URI endpointURL) throws RegistryException {
        Service service = null;
        Call call = null;
        String response = null;
        log.debug("\nRequest message:\n" + request);
        try {
            service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(endpointURL.toURL());
            SOAPBodyElement body = new SOAPBodyElement(new ByteArrayInputStream(request.getBytes("UTF-8")));
            Object[] soapBodies = new Object[]{body};
            Vector result = (Vector)call.invoke(soapBodies);
            response = ((SOAPBodyElement)result.elementAt(0)).getAsString();
        }
        catch (AxisFault fault) {
            fault.printStackTrace();
            try {
                Message msg = call.getResponseMessage();
                response = msg.getSOAPEnvelope().getFirstBody().getAsString();
            }
            catch (Exception ex) {
                throw new RegistryException(ex);
            }
        }
        catch (Exception ex) {
            throw new RegistryException(ex);
        }
        log.debug("\nResponse message:\n" + response);
        return response;
    }
}

