/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ConstantExpression
extends Expression {
    protected Object value;
    protected Expression localBase;

    public ConstantExpression() {
    }

    public ConstantExpression(Object newValue, Expression baseExpression) {
        this.value = newValue;
        this.localBase = baseExpression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ConstantExpression expression = (ConstantExpression)object;
        return this.getValue() == expression.getValue() || this.getValue() != null && this.getValue().equals(expression.getValue());
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getValue() != null) {
            hashCode += this.getValue().hashCode();
        }
        return hashCode;
    }

    public String descriptionOfNodeType() {
        return "Constant";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.localBase = this.localBase.copiedVersionFrom(alreadyDone);
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        Object value = this.getLocalBase().getFieldValue(this.getValue(), this.getSession());
        if (value == null) {
            printer.printNull(this);
        } else {
            printer.printPrimitive(value);
        }
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter printer) {
        printer.printPrimitive(this.getValue());
    }

    public void printJava(ExpressionJavaPrinter printer) {
        printer.printJava(this.getValue());
    }

    public Expression rebuildOn(Expression newBase) {
        ConstantExpression result = (ConstantExpression)this.clone();
        ((Expression)result).setLocalBase(this.getLocalBase().rebuildOn(newBase));
        return result;
    }

    public void setLocalBase(Expression e) {
        this.localBase = e;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        return this.localBase.getFieldValue(this.value, session);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.getValue()));
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        newFields.addElement(new DatabaseField("*"));
        this.printSQL(printer);
    }
}

