/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;

public class ParameterNode
extends Node {
    private String name;

    public ParameterNode() {
    }

    public ParameterNode(String newParameterName) {
        this.setParameterName(newParameterName);
    }

    public void validateParameter(ParseTreeContext context, Object contextType) {
        context.defineParameterType(this.name, contextType, this.getLine(), this.getColumn());
        this.setType(context.getParameterType(this.name));
    }

    public Expression generateExpression(GenerationContext context) {
        Class baseClass = context.getBaseQueryClass();
        ExpressionBuilder builder = new ExpressionBuilder(baseClass);
        Expression whereClause = builder.getParameter(this.getParameterName(), this.getType());
        return whereClause;
    }

    public String getAsString() {
        return this.getParameterName();
    }

    public String getParameterName() {
        return this.name;
    }

    public void setParameterName(String name) {
        this.name = name;
    }

    public boolean isParameterNode() {
        return true;
    }
}

