/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.XMLSimpleMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.queries.DirectMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class XMLAnyAttributeMappingNodeValue
extends XMLSimpleMappingNodeValue
implements ContainerValue {
    private XMLAnyAttributeMapping xmlAnyAttributeMapping;

    public XMLAnyAttributeMappingNodeValue(XMLAnyAttributeMapping xmlAnyAttributeMapping) {
        this.xmlAnyAttributeMapping = xmlAnyAttributeMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object iter;
        if (this.xmlAnyAttributeMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlAnyAttributeMapping.getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        DirectMapContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iter = cp.iteratorFor(collection))) {
            return false;
        }
        XPathFragment groupingElements = marshalRecord.openStartGroupingElements(namespaceResolver);
        ArrayList<String> extraNamespaces = new ArrayList<String>();
        NamespaceResolver nr = marshalRecord.getNamespaceResolver();
        while (cp.hasNext(iter)) {
            Object key = cp.next(iter, session);
            if (!(key instanceof QName)) continue;
            QName name = (QName)key;
            String value = cp.valueFromKey(key, collection).toString();
            String qualifiedName = name.getLocalPart();
            if (nr != null) {
                String prefix = nr.resolveNamespaceURI(name.getNamespaceURI());
                if (prefix != null && !prefix.equals("")) {
                    qualifiedName = prefix + ":" + qualifiedName;
                } else if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) {
                    String generatedPrefix = nr.generatePrefix();
                    qualifiedName = generatedPrefix + ":" + qualifiedName;
                    nr.put(generatedPrefix, name.getNamespaceURI());
                    extraNamespaces.add(generatedPrefix);
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", generatedPrefix, "xmlns:" + generatedPrefix, name.getNamespaceURI());
                }
            }
            marshalRecord.attribute(name.getNamespaceURI(), name.getLocalPart(), qualifiedName, value);
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            marshalRecord.getNamespaceResolver().removeNamespace((String)extraNamespaces.get(i));
        }
        marshalRecord.closeStartGroupingElements(groupingElements);
        return true;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        try {
            DirectMapContainerPolicy cp = (DirectMapContainerPolicy)this.xmlAnyAttributeMapping.getContainerPolicy();
            Object containerInstance = unmarshalRecord.getContainerInstance(this);
            QName key = new QName(namespaceURI, localName);
            cp.addInto(key, value, containerInstance, unmarshalRecord.getSession());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object getContainerInstance() {
        return this.xmlAnyAttributeMapping.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object container) {
        this.xmlAnyAttributeMapping.setAttributeValueInObject(object, container);
    }

    public DirectMapContainerPolicy getContainerPolicy() {
        return (DirectMapContainerPolicy)this.xmlAnyAttributeMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    public void marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
    }

    public XMLAnyAttributeMapping getMapping() {
        return this.xmlAnyAttributeMapping;
    }
}

