/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToManyMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient DatabaseTable relationTable;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> targetKeyFields;
    protected transient Vector<DatabaseField> sourceRelationKeyFields;
    protected transient Vector<DatabaseField> targetRelationKeyFields;
    protected transient DataModifyQuery deleteQuery;
    protected transient boolean hasCustomDeleteQuery = false;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient boolean hasCustomInsertQuery = false;
    protected HistoryPolicy historyPolicy;

    public ManyToManyMapping() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetKeyFields = NonSynchronizedVector.newInstance(1);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addSourceRelationKeyField(DatabaseField sourceRelationKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceRelationKeyFields().addElement(sourceRelationKeyField);
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
    }

    public void addSourceRelationKeyFieldName(String sourceRelationKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addSourceRelationKeyField(new DatabaseField(sourceRelationKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    public void addTargetRelationKeyField(DatabaseField targetRelationKeyField, DatabaseField targetPrimaryKeyField) {
        this.getTargetRelationKeyFields().addElement(targetRelationKeyField);
        this.getTargetKeyFields().addElement(targetPrimaryKeyField);
    }

    public void addTargetRelationKeyFieldName(String targetRelationKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addTargetRelationKeyField(new DatabaseField(targetRelationKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    @Override
    public Object clone() {
        ManyToManyMapping clone = (ManyToManyMapping)super.clone();
        clone.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        clone.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        return clone;
    }

    protected Vector extractKeyFromRelationRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceRelationKeyFields().size());
        for (int index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField relationField = this.getSourceRelationKeyFields().elementAt(index);
            DatabaseField sourceField = this.getSourceKeyFields().elementAt(index);
            Object value = row.get(relationField);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldEnum = this.getSourceKeyFields().elements();
        while (fieldEnum.hasMoreElements()) {
            DatabaseField field = fieldEnum.nextElement();
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        mappingBatchQuery.setShouldIncludeData(true);
        Enumeration<DatabaseField> relationFieldsEnum = this.getSourceRelationKeyFields().elements();
        while (relationFieldsEnum.hasMoreElements()) {
            mappingBatchQuery.getAdditionalFields().addElement(mappingBatchQuery.getExpressionBuilder().getTable(this.getRelationTable()).getField(relationFieldsEnum.nextElement()));
        }
        if (this.getHistoryPolicy() != null) {
            ExpressionBuilder builder = mappingBatchQuery.getExpressionBuilder();
            Expression twisted = batchQuery.getSelectionCriteria();
            if (query.getSession().getAsOfClause() != null) {
                builder.asOf(query.getSession().getAsOfClause());
            } else if (builder.getAsOfClause() == null) {
                builder.asOf(AsOfClause.NO_CLAUSE);
            }
            twisted = twisted.and(this.getHistoryPolicy().additionalHistoryExpression(builder));
            mappingBatchQuery.setSelectionCriteria(twisted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable<CacheKey, Object> referenceObjectsByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceObjectsByKey = this.getBatchReadObjects(query, session);
            mappingContainerPolicy = this.getContainerPolicy();
            if (referenceObjectsByKey == null) {
                ReadAllQuery batchQuery = (ReadAllQuery)query;
                ComplexQueryResult complexResult = (ComplexQueryResult)session.executeQuery((DatabaseQuery)batchQuery, argumentRow);
                Object results = complexResult.getResult();
                referenceObjectsByKey = new Hashtable<CacheKey, Object>();
                Enumeration rowsEnum = ((Vector)complexResult.getData()).elements();
                ContainerPolicy queryContainerPolicy = batchQuery.getContainerPolicy();
                Object elementsIterator = queryContainerPolicy.iteratorFor(results);
                while (queryContainerPolicy.hasNext(elementsIterator)) {
                    Object eachReferenceObject = queryContainerPolicy.next(elementsIterator, session);
                    CacheKey eachReferenceKey = new CacheKey(this.extractKeyFromRelationRow((AbstractRecord)rowsEnum.nextElement(), session));
                    if (!referenceObjectsByKey.containsKey(eachReferenceKey)) {
                        referenceObjectsByKey.put(eachReferenceKey, mappingContainerPolicy.containerInstance());
                    }
                    mappingContainerPolicy.addInto(eachReferenceObject, referenceObjectsByKey.get(eachReferenceKey), session);
                }
                this.setBatchReadObjects(referenceObjectsByKey, query, session);
            }
        }
        Object result = referenceObjectsByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression exp) {
        if (this.getHistoryPolicy() != null) {
            Expression result = super.getJoinCriteria(exp);
            Expression historyCriteria = this.getHistoryPolicy().additionalHistoryExpression(exp);
            if (result != null) {
                return result.and(historyCriteria);
            }
            if (historyCriteria != null) {
                return historyCriteria;
            }
            return null;
        }
        return super.getJoinCriteria(exp);
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    @Override
    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    @Override
    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getSourceRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public Vector getTargetKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public Vector getTargetRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    @Override
    public boolean hasDependency() {
        return this.isPrivateOwned() || !this.isReadOnly();
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeRelationTable(session);
        this.initializeSourceRelationKeys(session);
        this.initializeTargetRelationKeys(session);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(session);
        } else {
            this.initializeSourceKeys(session);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(session);
        } else {
            this.initializeTargetKeys(session);
        }
        if (this.getRelationTable().getName().indexOf(32) != -1) {
            String quoteChar = ((DatasourcePlatform)session.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (this.getRelationTable().getName().indexOf(quoteChar) == -1) {
                this.getRelationTable().setName(quoteChar + this.getRelationTable().getName() + quoteChar);
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeInsertQuery(session);
        this.initializeDeleteQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField sourceRelationKey = this.getSourceRelationKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Expression subExpression = ((Expression)builder).getField(sourceRelationKey).equal(builder.getParameter(sourceKey));
            expression = subExpression.and(expression);
        }
        statement.setWhereClause(expression);
        statement.setTable(this.getRelationTable());
        this.getDeleteAllQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        Expression expression;
        DatabaseField relationKey;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Enumeration<DatabaseField> relationKeyEnum = this.getSourceRelationKeyFields().elements();
        while (relationKeyEnum.hasMoreElements()) {
            relationKey = relationKeyEnum.nextElement();
            expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
            whereClause = expression.and(whereClause);
        }
        relationKeyEnum = this.getTargetRelationKeyFields().elements();
        while (relationKeyEnum.hasMoreElements()) {
            relationKey = relationKeyEnum.nextElement();
            expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
            whereClause = expression.and(whereClause);
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        statement.setTable(this.getRelationTable());
        statement.setWhereClause(whereClause);
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getRelationTable());
        DatabaseRecord joinRow = new DatabaseRecord();
        Enumeration<DatabaseField> targetEnum = this.getTargetRelationKeyFields().elements();
        while (targetEnum.hasMoreElements()) {
            joinRow.put(targetEnum.nextElement(), (Object)null);
        }
        Enumeration<DatabaseField> sourceEnum = this.getSourceRelationKeyFields().elements();
        while (sourceEnum.hasMoreElements()) {
            joinRow.put(sourceEnum.nextElement(), (Object)null);
        }
        statement.setModifyRow(joinRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(joinRow);
    }

    protected void initializeRelationTable(AbstractSession session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getRelationTable() == null || this.getRelationTableName().length() == 0) {
            throw DescriptorException.noRelationTable(this);
        }
        if (platform.getTableQualifier().length() > 0 && this.getRelationTable().getTableQualifier().length() == 0) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        Expression criteria;
        Expression expression;
        Expression exp2;
        Expression exp1;
        DatabaseField relationKey;
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression linkTable = null;
        Enumeration<DatabaseField> targetKeyEnum = this.getTargetKeyFields().elements();
        Enumeration<DatabaseField> relationKeyEnum = this.getTargetRelationKeyFields().elements();
        while (targetKeyEnum.hasMoreElements()) {
            relationKey = relationKeyEnum.nextElement();
            DatabaseField targetKey = targetKeyEnum.nextElement();
            if (linkTable == null) {
                linkTable = ((Expression)builder).getTable(relationKey.getTable());
            }
            exp1 = ((Expression)builder).getField(targetKey);
            exp2 = linkTable.getField(relationKey);
            expression = exp1.equal(exp2);
            criteria = this.getSelectionCriteria();
            criteria = criteria == null ? expression : expression.and(criteria);
            this.setSelectionCriteria(criteria);
        }
        relationKeyEnum = this.getSourceRelationKeyFields().elements();
        Enumeration<DatabaseField> sourceKeyEnum = this.getSourceKeyFields().elements();
        while (relationKeyEnum.hasMoreElements()) {
            relationKey = relationKeyEnum.nextElement();
            DatabaseField sourceKey = sourceKeyEnum.nextElement();
            exp1 = linkTable.getField(relationKey);
            exp2 = builder.getParameter(sourceKey);
            expression = exp1.equal(exp2);
            criteria = this.getSelectionCriteria();
            criteria = criteria == null ? expression : expression.and(criteria);
            this.setSelectionCriteria(criteria);
        }
    }

    protected void initializeSourceKeys(AbstractSession session) {
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField field = this.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getSourceKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    protected void initializeSourceRelationKeys(AbstractSession session) throws DescriptorException {
        if (this.getSourceRelationKeyFields().size() == 0) {
            throw DescriptorException.noSourceRelationKeysSpecified(this);
        }
        Enumeration<DatabaseField> entry = this.getSourceRelationKeyFields().elements();
        while (entry.hasMoreElements()) {
            DatabaseField field = entry.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, this);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(AbstractSession session) {
        for (int index = 0; index < this.getTargetKeyFields().size(); ++index) {
            DatabaseField field = this.getReferenceDescriptor().buildField(this.getTargetKeyFields().get(index));
            this.getTargetKeyFields().set(index, field);
        }
    }

    protected void initializeTargetKeysWithDefaults(AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getTargetKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    protected void initializeTargetRelationKeys(AbstractSession session) {
        if (this.getTargetRelationKeyFields().size() == 0) {
            throw DescriptorException.noTargetRelationKeysSpecified(this);
        }
        Enumeration<DatabaseField> targetEnum = this.getTargetRelationKeyFields().elements();
        while (targetEnum.hasMoreElements()) {
            DatabaseField field = targetEnum.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, this);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected void insertAddedObjectEntry(ObjectLevelModifyQuery query, Object objectAdded) throws DatabaseException, OptimisticLockException {
        int index;
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        for (index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField sourceRelationKey = this.getSourceRelationKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(sourceRelationKey, sourceKeyValue);
        }
        for (index = 0; index < this.getTargetRelationKeyFields().size(); ++index) {
            DatabaseField targetRelationKey = this.getTargetRelationKeyFields().elementAt(index);
            DatabaseField targetKey = this.getTargetKeyFields().elementAt(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(objectAdded, targetKey, query.getSession());
            databaseRow.put(targetRelationKey, targetKeyValue);
        }
        query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRow, query.getSession());
        }
    }

    public void insertIntoRelationTable(WriteObjectQuery query) throws DatabaseException {
        Object objects;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession()))) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        for (int index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField sourceRelationKey = this.getSourceRelationKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(sourceRelationKey, sourceKeyValue);
        }
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            for (int index = 0; index < this.getTargetRelationKeyFields().size(); ++index) {
                DatabaseField targetRelationKey = this.getTargetRelationKeyFields().elementAt(index);
                DatabaseField targetKey = this.getTargetKeyFields().elementAt(index);
                Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetKey, query.getSession());
                databaseRow.put(targetRelationKey, targetKeyValue);
            }
            query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRow, query.getSession());
        }
    }

    public void insertTargetObjects(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects)) {
            return;
        }
        Object objectsIterator = cp.iteratorFor(objects);
        while (cp.hasNext(objectsIterator)) {
            Object object = cp.next(objectsIterator, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isManyToManyMapping() {
        return true;
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(query, objectAdded, changeSet);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{ObjectAdded, query, objectAdded};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.insertAddedObjectEntry(query, objectAdded);
        }
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted) throws DatabaseException, OptimisticLockException {
        int index;
        DatabaseRecord databaseRow = new DatabaseRecord();
        for (index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField sourceRelationKey = this.getSourceRelationKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(sourceRelationKey, sourceKeyValue);
        }
        for (index = 0; index < this.getTargetRelationKeyFields().size(); ++index) {
            DatabaseField targetRelationKey = this.getTargetRelationKeyFields().elementAt(index);
            DatabaseField targetKey = this.getTargetKeyFields().elementAt(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(objectDeleted, targetKey, query.getSession());
            databaseRow.put(targetRelationKey, targetKeyValue);
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{ObjectRemoved, this.getDeleteQuery(), databaseRow};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            query.getSession().executeQuery((DatabaseQuery)this.getDeleteQuery(), databaseRow);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteQuery(), databaseRow, query.getSession());
            }
        }
        super.objectRemovedDuringUpdate(query, objectDeleted);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == PostInsert) {
            this.insertIntoRelationTable((WriteObjectQuery)event[1]);
        } else if (event[0] == ObjectRemoved) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == ObjectAdded) {
            this.insertAddedObjectEntry((WriteObjectQuery)event[1], event[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        this.insertTargetObjects(query);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{PostInsert, query};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.insertIntoRelationTable(query);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        Object objectsInMemoryModel = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(query);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objectsInMemoryModel, query);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        Object objectsIterator = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        if (this.shouldObjectModifyCascadeToParts(query)) {
            objectsIterator = containerPolicy.iteratorFor(objects);
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        query.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), query.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), query.getTranslationRow(), query.getSession());
        }
        if (this.shouldObjectModifyCascadeToParts(query) && objects != null) {
            while (containerPolicy.hasNext(objectsIterator)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(containerPolicy.next(objectsIterator, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
        Enumeration<DatabaseField> sourceFieldsEnum = this.getSourceKeyFields().elements();
        while (sourceFieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = sourceFieldsEnum.nextElement();
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    public void setCustomDeleteQuery(DataModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteQuery(query);
    }

    protected void setHasCustomDeleteQuery(boolean hasCustomDeleteQuery) {
        this.hasCustomDeleteQuery = hasCustomDeleteQuery;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomInsertQuery(query);
    }

    public void setRelationTable(DatabaseTable relationTable) {
        this.relationTable = relationTable;
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setMapping(this);
        }
    }

    public void setRelationTableName(String tableName) {
        this.relationTable = new DatabaseTable(tableName);
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        this.getInsertQuery().setSessionName(name);
        this.getDeleteQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setSourceRelationKeyFieldName(String sourceRelationKeyFieldName) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(sourceRelationKeyFieldName));
    }

    public void setSourceRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceRelationKeyFields(fields);
    }

    public void setSourceRelationKeyFields(Vector<DatabaseField> sourceRelationKeyFields) {
        this.sourceRelationKeyFields = sourceRelationKeyFields;
    }

    public void setTargetKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetKeyFields(fields);
    }

    public void setTargetKeyFields(Vector<DatabaseField> targetKeyFields) {
        this.targetKeyFields = targetKeyFields;
    }

    public void setTargetRelationKeyFieldName(String targetRelationKeyFieldName) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(targetRelationKeyFieldName));
    }

    public void setTargetRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetRelationKeyFields(fields);
    }

    public void setTargetRelationKeyFields(Vector<DatabaseField> targetRelationKeyFields) {
        this.targetRelationKeyFields = targetRelationKeyFields;
    }

    @Override
    protected ReadQuery prepareHistoricalQuery(ReadQuery targetQuery, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        if (this.getHistoryPolicy() != null) {
            if (targetQuery == this.getSelectionQuery()) {
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                targetQuery.setIsExecutionClone(true);
            }
            if (targetQuery.getSelectionCriteria() == this.getSelectionQuery().getSelectionCriteria()) {
                targetQuery.setSelectionCriteria((Expression)targetQuery.getSelectionCriteria().clone());
            }
            if (sourceQuery.getSession().getAsOfClause() != null) {
                ((ObjectLevelReadQuery)targetQuery).setAsOfClause(sourceQuery.getSession().getAsOfClause());
            } else if (((ObjectLevelReadQuery)targetQuery).getAsOfClause() == null) {
                ((ObjectLevelReadQuery)targetQuery).setAsOfClause(AsOfClause.NO_CLAUSE);
            }
            Expression temporalExpression = this.getHistoryPolicy().additionalHistoryExpression(targetQuery.getSelectionCriteria().getBuilder());
            targetQuery.setSelectionCriteria(targetQuery.getSelectionCriteria().and(temporalExpression));
        }
        return targetQuery;
    }
}

