/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.ObjectUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.unmapped.DefaultUnmappedContentHandler;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class UnmarshalRecord
extends XMLRecord
implements ContentHandler,
LexicalHandler {
    protected static final String EMPTY_STRING = "";
    public static final UnmappedContentHandler DEFAULT_UNMAPPED_CONTENT_HANDLER = new DefaultUnmappedContentHandler();
    private XMLReader xmlReader;
    private TreeObjectBuilder treeObjectBuilder;
    private XPathFragment xPathFragment = new XPathFragment();
    private XPathNode xPathNode;
    private int levelIndex = 0;
    private UnmarshalRecord childRecord;
    private UnmarshalRecord parentRecord;
    private DOMRecord transformationRecord;
    private List selfRecords;
    private Map indexMap;
    private Map namespaceMap;
    private Map uriToPrefixMap;
    private List nullCapableValues;
    private Map containersMap;
    private StrBuffer stringBuffer = new StrBuffer();
    private boolean isBufferCDATA = false;
    private Attributes attributes;
    private QName typeQName;
    private String rootElementName;
    private String rootElementNamespaceUri;
    private XMLUnmarshaller unmarshaller;
    private SAXFragmentBuilder fragmentBuilder;
    private String encoding;
    private String version;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean isSelfRecord;
    private UnmarshalContext unmarshalContext;

    public UnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        this.treeObjectBuilder = treeObjectBuilder;
        if (null != treeObjectBuilder) {
            this.xPathNode = treeObjectBuilder.getRootXPathNode();
            if (null != treeObjectBuilder.getNullCapableValues()) {
                this.nullCapableValues = new ArrayList();
                this.nullCapableValues.addAll(treeObjectBuilder.getNullCapableValues());
            }
        }
        this.fragmentBuilder = new SAXFragmentBuilder(this);
        this.isSelfRecord = false;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public String transformToXML() {
        throw XMLMarshalException.operationNotSupported("transformToXML");
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public UnmarshalRecord getChildRecord() {
        return this.childRecord;
    }

    public void setChildRecord(UnmarshalRecord childRecord) {
        this.childRecord = childRecord;
        if (null != childRecord) {
            childRecord.setParentRecord(this);
            childRecord.session = this.session;
            childRecord.xmlReader = this.xmlReader;
            childRecord.setFragmentBuilder(this.getFragmentBuilder());
        }
    }

    public UnmarshalRecord getParentRecord() {
        return this.parentRecord;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void setParentRecord(UnmarshalRecord parentRecord) {
        this.parentRecord = parentRecord;
    }

    public DOMRecord getTransformationRecord() {
        return this.transformationRecord;
    }

    public void setTransformationRecord(DOMRecord transformationRecord) {
        this.transformationRecord = transformationRecord;
    }

    public Map getNamespaceMap() {
        return this.namespaceMap;
    }

    public void setNamespaceMap(Map namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public Map getUriToPrefixMap() {
        return this.uriToPrefixMap;
    }

    public void setUriToPrefixMap(Map uriToPrefixMap) {
        this.uriToPrefixMap = uriToPrefixMap;
    }

    public List getNullCapableValues() {
        return this.nullCapableValues;
    }

    public void removeNullCapableValue(NullCapableValue nullCapableValue) {
        if (null == this.getNullCapableValues()) {
            return;
        }
        this.getNullCapableValues().remove(nullCapableValue);
    }

    public Object getContainerInstance(ContainerValue containerValue) {
        if (null == this.containersMap) {
            return null;
        }
        return this.containersMap.get(containerValue);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = location;
    }

    public StrBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.getParentRecord() == null && locator instanceof Locator2) {
            Locator2 loc = (Locator2)locator;
            this.setEncoding(loc.getEncoding());
            this.setVersion(loc.getXMLVersion());
        }
    }

    public Object get(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        NamespaceResolver namespaceResolver = xmlField.getNamespaceResolver();
        String namespaceURI = EMPTY_STRING;
        if (null != namespaceResolver && null == (namespaceURI = namespaceResolver.resolveNamespacePrefix(lastFragment.getPrefix()))) {
            namespaceURI = EMPTY_STRING;
        }
        return this.attributes.getValue(namespaceURI, lastFragment.getLocalName());
    }

    public XPathNode getXPathNode() {
        return this.xPathNode;
    }

    public void startDocument() throws SAXException {
        this.startDocument(null);
    }

    public void startDocument(XMLMapping selfRecordMapping) throws SAXException {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
            this.unmarshalContext = xmlDescriptor.isSequencedObject() ? new SequencedUnmarshalContext() : ObjectUnmarshalContext.getInstance();
            Object object = this.getXMLReader().getCurrentObject(this.session, selfRecordMapping);
            if (object == null) {
                object = this.treeObjectBuilder.buildNewInstance();
            }
            this.setCurrentObject(object);
            if (this.unmarshaller != null && this.unmarshaller.getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.unmarshaller.getUnmarshalListener().beforeUnmarshal(object, this.parentRecord.getCurrentObject());
                } else {
                    this.unmarshaller.getUnmarshalListener().beforeUnmarshal(object, null);
                }
            }
            if (this.parentRecord != null) {
                this.xmlReader.newObjectEvent(object, this.parentRecord.getCurrentObject(), selfRecordMapping);
            } else {
                this.xmlReader.newObjectEvent(object, null, selfRecordMapping);
            }
            List containerValues = this.treeObjectBuilder.getContainerValues();
            if (null != containerValues) {
                this.containersMap = new HashMap(containerValues.size());
                int containerValuesSize = containerValues.size();
                for (int x = 0; x < containerValuesSize; ++x) {
                    ContainerValue containerValue = (ContainerValue)containerValues.get(x);
                    Object containerInstance = containerValue.getContainerInstance();
                    this.containersMap.put(containerValue, containerInstance);
                }
            }
            if (null != this.xPathNode.getSelfChildren()) {
                int selfChildrenSize = this.xPathNode.getSelfChildren().size();
                this.selfRecords = new ArrayList(selfChildrenSize);
                for (int x = 0; x < selfChildrenSize; ++x) {
                    XPathNode selfNode = (XPathNode)this.xPathNode.getSelfChildren().get(x);
                    if (null == selfNode.getNodeValue()) continue;
                    this.selfRecords.add(selfNode.getNodeValue().buildSelfRecord(this, this.attributes));
                }
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void endDocument() throws SAXException {
        XMLDescriptor xmlDescriptor;
        Object object = this.getCurrentObject();
        if (null != this.selfRecords) {
            int selfRecordsSize = this.selfRecords.size();
            for (int x = 0; x < selfRecordsSize; ++x) {
                ((UnmarshalRecord)this.selfRecords.get(x)).endDocument();
            }
        }
        try {
            XMLDescriptor xmlDescriptor2;
            List transformationMappings;
            if (null != this.containersMap) {
                for (ContainerValue containerValue : this.containersMap.keySet()) {
                    Object containerInstance = this.containersMap.get(containerValue);
                    containerValue.setContainerInstance(object, containerInstance);
                }
            }
            if (null != this.getNullCapableValues()) {
                int nullValuesSize = this.getNullCapableValues().size();
                for (int x = 0; x < nullValuesSize; ++x) {
                    NullCapableValue nullCapableValue = (NullCapableValue)this.getNullCapableValues().get(x);
                    nullCapableValue.setNullValue(object, this.session);
                }
            }
            if (null != (transformationMappings = this.treeObjectBuilder.getTransformationMappings())) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(this.session);
                int transformationMappingsSize = transformationMappings.size();
                for (int x = 0; x < transformationMappingsSize; ++x) {
                    AbstractTransformationMapping transformationMapping = (AbstractTransformationMapping)transformationMappings.get(x);
                    transformationMapping.readFromRowIntoObject(this.transformationRecord, null, object, query, this.session);
                }
            }
            if (this.unmarshaller != null && this.unmarshaller.getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.unmarshaller.getUnmarshalListener().afterUnmarshal(object, this.parentRecord.getCurrentObject());
                } else {
                    this.unmarshaller.getUnmarshalListener().afterUnmarshal(object, null);
                }
            }
            if ((xmlDescriptor2 = (XMLDescriptor)this.session.getDescriptor(object)) != null && xmlDescriptor2.getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(object);
                event.setSession(this.session);
                event.setRecord(this);
                event.setEventCode(8);
                xmlDescriptor2.getEventManager().executeEvent(event);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
        if (this.session.isUnitOfWork() && (xmlDescriptor = (XMLDescriptor)this.session.getDescriptor(object)) != null && xmlDescriptor.getPrimaryKeyFieldNames().size() > 0) {
            Vector pk = this.treeObjectBuilder.extractPrimaryKeyFromObject(object, this.session);
            CacheKey key = this.session.getIdentityMapAccessorInstance().acquireDeferredLock(pk, xmlDescriptor.getJavaClass(), xmlDescriptor);
            key.setRecord(this);
            key.setObject(object);
            key.releaseDeferredLock();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Stack<String> uriStack;
        if (null == this.namespaceMap) {
            this.namespaceMap = new HashMap();
        }
        if (this.uriToPrefixMap == null) {
            this.uriToPrefixMap = new HashMap();
        }
        if ((uriStack = (Stack<String>)this.namespaceMap.get(prefix)) == null) {
            uriStack = new Stack<String>();
            this.namespaceMap.put(prefix, uriStack);
        }
        uriStack.push(uri);
        Stack<String> prefixStack = (Stack<String>)this.uriToPrefixMap.get(uri);
        if (prefixStack == null) {
            prefixStack = new Stack<String>();
            this.uriToPrefixMap.put(uri, prefixStack);
        }
        prefixStack.push(prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Stack prefixStack;
        if (null == this.namespaceMap) {
            return;
        }
        Stack uriStack = (Stack)this.namespaceMap.get(prefix);
        String uri = null;
        if (uriStack != null && uriStack.size() > 0) {
            uri = (String)uriStack.pop();
        }
        if (uri != null && this.uriToPrefixMap != null && (prefixStack = (Stack)this.uriToPrefixMap.get(uri)) != null && prefixStack.size() > 0) {
            prefixStack.pop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (null != this.xPathNode.getXPathFragment() && this.xPathNode.getXPathFragment().nameIsText() && null != this.xPathNode.getUnmarshalNodeValue()) {
            this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
            if (this.xPathNode.getParent() != null) {
                this.xPathNode = this.xPathNode.getParent();
            }
        }
        if (this.rootElementName == null) {
            this.rootElementName = qName;
            this.rootElementNamespaceUri = namespaceURI;
            this.schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            this.noNamespaceSchemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        }
        try {
            XPathNode node;
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    ((UnmarshalRecord)this.selfRecords.get(x)).startElement(namespaceURI, localName, qName, atts);
                }
            }
            if (null == (node = this.getNonAttributeXPathNode(namespaceURI, localName, qName))) {
                NodeValue parentNodeValue = this.xPathNode.getUnmarshalNodeValue();
                if (null == this.xPathNode.getXPathFragment() && parentNodeValue != null) {
                    XPathFragment parentFragment = new XPathFragment();
                    if (EMPTY_STRING.equals(namespaceURI)) {
                        parentFragment.setLocalName(qName);
                        parentFragment.setNamespaceURI(null);
                    } else {
                        parentFragment.setLocalName(localName);
                        parentFragment.setNamespaceURI(namespaceURI);
                    }
                    if (parentNodeValue.startElement(parentFragment, this, atts)) {
                        ++this.levelIndex;
                        return;
                    }
                    this.startUnmappedElement(namespaceURI, localName, qName, atts);
                    return;
                }
                ++this.levelIndex;
                this.startUnmappedElement(namespaceURI, localName, qName, atts);
                return;
            }
            this.xPathNode = node;
            this.unmarshalContext.startElement(this);
            ++this.levelIndex;
            NodeValue nodeValue = node.getUnmarshalNodeValue();
            if (null != nodeValue && !nodeValue.startElement(this.xPathFragment, this, atts)) {
                this.startUnmappedElement(namespaceURI, localName, qName, atts);
                return;
            }
            int i = 0;
            while (i < atts.getLength()) {
                String qname;
                String attNamespace = atts.getURI(i);
                String attLocalName = atts.getLocalName(i);
                String value = atts.getValue(i);
                NodeValue attributeNodeValue = null;
                if ((attLocalName == null || attLocalName.length() == 0) && (qname = atts.getQName(i)) != null && qname.length() > 0) {
                    String attPrefix;
                    int idx = qname.indexOf(":");
                    attLocalName = qname.substring(idx <= 0 ? 0 : idx + 1, qname.length());
                    String string = attPrefix = idx == -1 ? null : qname.substring(0, idx);
                    if (attPrefix != null && attPrefix.equalsIgnoreCase("xmlns") || attPrefix == null && attLocalName.equalsIgnoreCase("xmlns")) {
                        attNamespace = "http://www.w3.org/2000/xmlns/";
                    }
                }
                if (this.selfRecords != null) {
                    for (int j = 0; j < this.selfRecords.size(); ++j) {
                        UnmarshalRecord nestedRecord = (UnmarshalRecord)this.selfRecords.get(j);
                        attributeNodeValue = nestedRecord.getAttributeChildNodeValue(attNamespace, attLocalName);
                        if (attributeNodeValue == null) continue;
                        attributeNodeValue.attribute(nestedRecord, attNamespace, attLocalName, value);
                    }
                }
                if (attributeNodeValue == null) {
                    attributeNodeValue = this.getAttributeChildNodeValue(attNamespace, attLocalName);
                    if (attributeNodeValue != null) {
                        attributeNodeValue.attribute(this, attNamespace, attLocalName, value);
                    } else if (this.xPathNode.getAnyAttributeNodeValue() != null) {
                        this.xPathNode.getAnyAttributeNodeValue().attribute(this, attNamespace, attLocalName, value);
                    }
                }
                ++i;
            }
            return;
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader) throw e;
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void startUnmappedElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        UnmappedContentHandler unmappedContentHandler;
        if (null != this.selfRecords || null == this.xmlReader || this.isSelfRecord()) {
            return;
        }
        Class unmappedContentHandlerClass = this.unmarshaller.getUnmappedContentHandlerClass();
        if (null == unmappedContentHandlerClass) {
            unmappedContentHandler = DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
            }
            catch (ClassCastException e) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
            catch (InstantiationException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
        }
        UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(this, unmappedContentHandler);
        unmappedContentHandlerWrapper.startElement(namespaceURI, localName, qName, atts);
        this.xmlReader.setContentHandler(unmappedContentHandlerWrapper);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    ((UnmarshalRecord)this.selfRecords.get(x)).endElement(namespaceURI, localName, qName);
                }
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
                if (this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
            if (null != this.xPathNode.getParent()) {
                if (EMPTY_STRING.equals(namespaceURI)) {
                    this.xPathFragment.setLocalName(qName);
                    this.xPathFragment.setNamespaceURI(null);
                } else {
                    this.xPathFragment.setLocalName(localName);
                    this.xPathFragment.setNamespaceURI(namespaceURI);
                }
                if (this.xPathFragment.qNameEquals(this.xPathNode.getXPathFragment()) && this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
            this.unmarshalContext.endElement(this);
            this.typeQName = null;
            --this.levelIndex;
            if (0 == this.levelIndex && null != this.getParentRecord() && !this.isSelfRecord()) {
                this.endDocument();
                UnmarshalRecord pRec = this.getParentRecord();
                while (pRec.isSelfRecord()) {
                    pRec = pRec.getParentRecord();
                }
                pRec.endElement(namespaceURI, localName, qName);
                this.xmlReader.setContentHandler(pRec);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader || null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    ((UnmarshalRecord)this.selfRecords.get(x)).characters(ch, start, length);
                }
            }
            XPathNode textNode = null;
            if (null != this.xPathNode.getNonAttributeChildrenMap() && null == (textNode = (XPathNode)this.xPathNode.getNonAttributeChildrenMap().get(XPathFragment.TEXT_FRAGMENT)) && (textNode = (XPathNode)this.xPathNode.getNonAttributeChildrenMap().get(XPathFragment.ANY_FRAGMENT)) != null) {
                if (0 == length) {
                    return;
                }
                String tmpString = new String(ch, start, length);
                if (EMPTY_STRING.equals(tmpString.trim())) {
                    return;
                }
            }
            if (null != textNode) {
                this.xPathNode = textNode;
                this.unmarshalContext.characters(this);
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.stringBuffer.append(ch, start, length);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    protected XPathNode getNonAttributeXPathNode(String namespaceURI, String localName, String qName) {
        if (0 == this.levelIndex) {
            return this.xPathNode;
        }
        if (EMPTY_STRING.equals(namespaceURI)) {
            this.xPathFragment.setLocalName(qName);
            this.xPathFragment.setNamespaceURI(null);
        } else {
            this.xPathFragment.setLocalName(localName);
            this.xPathFragment.setNamespaceURI(namespaceURI);
        }
        XPathNode resultNode = null;
        Map nonAttributeChildrenMap = this.xPathNode.getNonAttributeChildrenMap();
        if (null != nonAttributeChildrenMap && null == (resultNode = (XPathNode)nonAttributeChildrenMap.get(this.xPathFragment))) {
            Integer newIndex;
            if (null == this.indexMap) {
                this.indexMap = new HashMap();
                newIndex = new Integer(1);
            } else {
                Integer oldIndex = (Integer)this.indexMap.get(this.xPathFragment);
                newIndex = null == oldIndex ? new Integer(1) : new Integer(oldIndex + 1);
            }
            this.indexMap.put(this.xPathFragment, newIndex);
            XPathFragment positionalFragment = new XPathFragment();
            positionalFragment.setNamespaceURI(this.xPathFragment.getNamespaceURI());
            positionalFragment.setLocalName(this.xPathFragment.getLocalName());
            positionalFragment.setIndexValue(newIndex);
            resultNode = (XPathNode)nonAttributeChildrenMap.get(positionalFragment);
            if (null == resultNode) {
                resultNode = (XPathNode)nonAttributeChildrenMap.get(XPathFragment.ANY_FRAGMENT);
            }
        }
        return resultNode;
    }

    public String resolveNamespacePrefix(String prefix) {
        Stack uriStack;
        String namespaceURI = null;
        if (prefix == null) {
            prefix = EMPTY_STRING;
        }
        if (null != this.namespaceMap && (uriStack = (Stack)this.namespaceMap.get(prefix)) != null && uriStack.size() > 0) {
            namespaceURI = (String)uriStack.peek();
        }
        if (null == namespaceURI && null != this.getParentRecord()) {
            namespaceURI = this.getParentRecord().resolveNamespacePrefix(prefix);
        }
        return namespaceURI;
    }

    public String resolveNamespaceUri(String uri) {
        Stack prefixStack;
        String prefix = null;
        if (null != this.uriToPrefixMap && (prefixStack = (Stack)this.uriToPrefixMap.get(uri)) != null && prefixStack.size() > 0) {
            prefix = (String)prefixStack.peek();
        }
        if (null == prefix && null != this.getParentRecord()) {
            prefix = this.getParentRecord().resolveNamespaceUri(uri);
        }
        return prefix;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("()");
        return writer.toString();
    }

    public NodeValue getSelfNodeValueForAttribute(String namespace, String localName) {
        if (this.selfRecords != null) {
            for (int i = 0; i < this.selfRecords.size(); ++i) {
                UnmarshalRecord nestedRecord = (UnmarshalRecord)this.selfRecords.get(i);
                NodeValue node = nestedRecord.getAttributeChildNodeValue(namespace, localName);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public NodeValue getAttributeChildNodeValue(String namespace, String localName) {
        Map attributeChildrenMap = this.xPathNode.getAttributeChildrenMap();
        if (attributeChildrenMap != null) {
            this.xPathFragment.setLocalName(localName);
            if (EMPTY_STRING.equals(namespace)) {
                this.xPathFragment.setNamespaceURI(null);
            } else {
                this.xPathFragment.setNamespaceURI(namespace);
            }
            XPathNode node = (XPathNode)attributeChildrenMap.get(this.xPathFragment);
            if (node != null) {
                return node.getUnmarshalNodeValue();
            }
        }
        return null;
    }

    public XMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public SAXFragmentBuilder getFragmentBuilder() {
        return this.fragmentBuilder;
    }

    public void setFragmentBuilder(SAXFragmentBuilder builder) {
        this.fragmentBuilder = builder;
    }

    public void resetStringBuffer() {
        this.getStringBuffer().reset();
        this.isBufferCDATA = false;
    }

    public boolean isBufferCDATA() {
        return this.isBufferCDATA;
    }

    public void comment(char[] data, int start, int length) {
    }

    public void startCDATA() {
        if (this.xPathNode.getUnmarshalNodeValue() != null) {
            this.isBufferCDATA = true;
        }
    }

    public void endCDATA() {
    }

    public void startEntity(String entity) {
    }

    public void endEntity(String entity) {
    }

    public void startDTD(String a, String b, String c) {
    }

    public void endDTD() {
    }

    public void setSelfRecord(boolean isSelfRecord) {
        this.isSelfRecord = isSelfRecord;
    }

    public boolean isSelfRecord() {
        return this.isSelfRecord;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setAttributeValue(Object value, DatabaseMapping mapping) {
        this.unmarshalContext.setAttributeValue(this, value, mapping);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value, Object collection) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value, collection);
    }

    public void reference(Reference reference) {
        this.unmarshalContext.reference(reference);
    }

    public void unmappedContent() {
        this.unmarshalContext.unmappedContent(this);
    }
}

