/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.eclipse.persistence.exceptions.DiscoveryException;
import org.eclipse.persistence.internal.sessions.coordination.ProfileDiscoveryStartedCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileDiscoveryStoppedCommand;
import org.eclipse.persistence.internal.sessions.coordination.ServiceAnnouncement;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;

public class DiscoveryManager
implements Runnable {
    public static final String DEFAULT_MULTICAST_GROUP = "226.10.12.64";
    public static final int DEFAULT_MULTICAST_PORT = 3121;
    public static final int DEFAULT_PACKET_TIME_TO_LIVE = 2;
    public static final int DEFAULT_ANNOUNCEMENT_DELAY = 1000;
    protected String multicastGroupAddress = "226.10.12.64";
    protected int multicastPort = 3121;
    protected MulticastSocket communicationSocket;
    protected int packetTimeToLive = 2;
    protected boolean stopListening = false;
    protected int announcementDelay = 1000;
    protected RemoteCommandManager rcm;

    public DiscoveryManager(RemoteCommandManager mgr) {
        this.rcm = mgr;
    }

    public DiscoveryManager(String address, int port, RemoteCommandManager mgr) {
        this(mgr);
        this.multicastGroupAddress = address;
        this.multicastPort = port;
    }

    public DiscoveryManager(String address, int port, int delay, RemoteCommandManager mgr) {
        this(address, port, mgr);
        this.announcementDelay = delay;
    }

    public void announceSession() {
        this.rcm.logDebug("sending_announcement", null);
        ServiceAnnouncement outMsg = new ServiceAnnouncement(this.rcm.getServiceId());
        byte[] outBytes = outMsg.toBytes();
        try {
            DatagramPacket sendPacket = new DatagramPacket(outBytes, outBytes.length, InetAddress.getByName(this.multicastGroupAddress), this.multicastPort);
            this.getCommunicationSocket().send(sendPacket);
            Object[] args = null;
            this.rcm.logInfo("announcement_sent", args);
        }
        catch (Exception ex) {
            DiscoveryException discoveryEx = DiscoveryException.errorSendingAnnouncement(ex);
            this.rcm.handleException(discoveryEx);
        }
    }

    public void startDiscovery() {
        if (this.rcm.isCommandProcessorASession()) {
            this.rcm.getCommandProcessor().processCommand(new ProfileDiscoveryStartedCommand());
        }
        if (this.isDiscoveryStopped()) {
            this.rcm.getServerPlatform().launchContainerRunnable(this);
        }
    }

    public void stopDiscovery() {
        if (this.rcm.isCommandProcessorASession()) {
            this.rcm.getCommandProcessor().processCommand(new ProfileDiscoveryStoppedCommand());
        }
        this.stopListening();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.communicationSocket = null;
    }

    public boolean isDiscoveryStopped() {
        return this.communicationSocket == null;
    }

    public void createCommunicationSocket() {
        Object[] args = new Object[]{this.multicastGroupAddress, "" + this.multicastPort};
        this.rcm.logDebug("initializing_discovery_resources", args);
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.multicastPort);
                this.communicationSocket.setTimeToLive(this.getPacketTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.multicastGroupAddress));
            }
            catch (IOException ex) {
                DiscoveryException discoveryEx = DiscoveryException.errorJoiningMulticastGroup(ex);
                this.rcm.handleException(discoveryEx);
            }
        }
    }

    public MulticastSocket getCommunicationSocket() {
        return this.communicationSocket;
    }

    public void run() {
        this.createCommunicationSocket();
        this.rcm.getTransportManager().createLocalConnection();
        try {
            Thread.sleep(this.announcementDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.announceSession();
        this.startListening();
    }

    public void startListening() {
        byte[] recvBuf = new byte[128];
        this.stopListening = false;
        this.rcm.logInfo("discovery_manager_active", null);
        while (!this.stopListening) {
            ServiceAnnouncement inMsg;
            DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
            try {
                this.getCommunicationSocket().receive(recvPacket);
            }
            catch (IOException exception) {
                if (this.stopListening) {
                    this.rcm.logInfo("discovery_manager_stopped", null);
                    return;
                }
                this.rcm.handleException(DiscoveryException.errorReceivingAnnouncement(exception));
            }
            try {
                inMsg = new ServiceAnnouncement(recvPacket.getData());
            }
            catch (Exception ex) {
                Object[] args = new Object[]{ex};
                this.rcm.logWarning("received_corrupt_announcement", args);
                continue;
            }
            if (this.rcm.getServiceId().getId().equals(inMsg.getServiceId().getId()) || !this.rcm.getServiceId().getChannel().equalsIgnoreCase(inMsg.getServiceId().getChannel())) continue;
            this.receivedAnnouncement(inMsg.getServiceId());
        }
    }

    public void stopListening() {
        this.stopListening = true;
        if (this.getCommunicationSocket() != null) {
            this.getCommunicationSocket().close();
        }
    }

    public void receivedAnnouncement(ServiceId serviceId) {
        Object[] args = new Object[]{serviceId};
        this.rcm.logInfo("announcement_received", args);
        this.rcm.newServiceDiscovered(serviceId);
    }

    public void setAnnouncementDelay(int millisecondsToDelay) {
        this.announcementDelay = millisecondsToDelay;
    }

    public int getAnnouncementDelay() {
        return this.announcementDelay;
    }

    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    public void setMulticastGroupAddress(String address) {
        this.multicastGroupAddress = address;
    }

    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    protected void shallowCopy(DiscoveryManager dmgr) {
        this.multicastGroupAddress = dmgr.multicastGroupAddress;
        this.multicastPort = dmgr.multicastPort;
        this.announcementDelay = dmgr.announcementDelay;
        this.rcm = dmgr.rcm;
    }

    public int getPacketTimeToLive() {
        return this.packetTimeToLive;
    }

    public void setPacketTimeToLive(int newPacketTimeToLive) {
        this.packetTimeToLive = newPacketTimeToLive;
    }
}

