/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import org.hibernate.ejb.Ejb3Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingHelper {
    private static final Logger log = LoggerFactory.getLogger(NamingHelper.class);
    private static final NamingListener LISTENER = new NamespaceChangeListener(){

        public void objectAdded(NamingEvent evt) {
            log.debug("An Ejb3Configuration was successfully bound to name: {}", (Object)evt.getNewBinding().getName());
        }

        public void objectRemoved(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            log.info("An Ejb3Configuration was unbound from name: {}", (Object)name);
        }

        public void objectRenamed(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            log.info("An Ejb3Configuration was renamed from name: {}", (Object)name);
        }

        public void namingExceptionThrown(NamingExceptionEvent evt) {
            log.warn("Naming exception occurred accessing Ejb3Configuration", evt.getException());
        }
    };

    private NamingHelper() {
    }

    public static void bind(Ejb3Configuration cfg) {
        String name = cfg.getHibernateConfiguration().getProperty("hibernate.ejb.configuration_jndi_name");
        if (name == null) {
            log.debug("No JNDI name configured for binding Ejb3Configuration");
        } else {
            log.info("Ejb3Configuration name: {}", (Object)name);
            try {
                InitialContext ctx = org.hibernate.util.NamingHelper.getInitialContext(cfg.getProperties());
                org.hibernate.util.NamingHelper.bind(ctx, name, cfg);
                log.info("Bound Ejb3Configuration to JNDI name: {}", (Object)name);
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, LISTENER);
            }
            catch (InvalidNameException ine) {
                log.error("Invalid JNDI name: " + name, ine);
            }
            catch (NamingException ne) {
                log.warn("Could not bind Ejb3Configuration to JNDI", ne);
            }
            catch (ClassCastException cce) {
                log.warn("InitialContext did not implement EventContext");
            }
        }
    }
}

