/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.IndexInteractionType;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

class DeleteWorkDelegate
implements LuceneWorkDelegate {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;

    DeleteWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    public IndexInteractionType getIndexInteractionType() {
        return IndexInteractionType.PREFER_INDEXWRITER;
    }

    public void performWork(LuceneWork work, IndexWriter writer) {
        Class entityType = work.getEntityClass();
        log.trace("Removing {}#{} by query.", entityType, (Object)work.getId());
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(entityType);
        BooleanQuery entityDeletionQuery = new BooleanQuery();
        TermQuery idQueryTerm = new TermQuery(builder.getTerm(work.getId()));
        entityDeletionQuery.add(idQueryTerm, BooleanClause.Occur.MUST);
        Term classNameQueryTerm = new Term("_hibernate_class", entityType.getName());
        TermQuery classNameQuery = new TermQuery(classNameQueryTerm);
        entityDeletionQuery.add(classNameQuery, BooleanClause.Occur.MUST);
        try {
            writer.deleteDocuments(entityDeletionQuery);
        }
        catch (Exception e) {
            String message = "Unable to remove " + entityType + "#" + work.getId() + " from index.";
            throw new SearchException(message, e);
        }
    }

    public void performWork(LuceneWork work, IndexReader reader) {
        Class entityType = work.getEntityClass();
        log.trace("Removing {}#{} from Lucene index.", entityType, (Object)work.getId());
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(entityType);
        Term term = builder.getTerm(work.getId());
        TermDocs termDocs = null;
        try {
            termDocs = reader.termDocs(term);
            String entityName = entityType.getName();
            while (termDocs.next()) {
                int docIndex = termDocs.doc();
                if (!entityName.equals(reader.document(docIndex).get("_hibernate_class"))) continue;
                reader.deleteDocument(docIndex);
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to remove from Lucene index: " + entityType + "#" + work.getId(), e);
        }
        finally {
            if (termDocs != null) {
                try {
                    termDocs.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close termDocs properly", e);
                }
            }
        }
    }
}

