/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class DirectoryProviderHelper {
    private static final Logger log = LoggerFactory.make();
    private static final String ROOTINDEX_PROP_NAME = "sourceBase";
    private static final String RELATIVEINDEX_PROP_NAME = "source";
    public static final String COPYBUFFERSIZE_PROP_NAME = "buffer_size_on_copy";

    public static File getSourceDirectory(String directoryProviderName, Properties properties, boolean needWritePermissions) {
        File sourceDirectory;
        String root = properties.getProperty(ROOTINDEX_PROP_NAME);
        String relative = properties.getProperty(RELATIVEINDEX_PROP_NAME);
        if (log.isTraceEnabled()) {
            log.trace("Guess source directory from {} {} and {} {}", new Object[]{ROOTINDEX_PROP_NAME, root != null ? root : "<null>", RELATIVEINDEX_PROP_NAME, relative != null ? relative : "<null>"});
        }
        if (relative == null) {
            relative = directoryProviderName;
        }
        if (StringHelper.isEmpty(root)) {
            log.debug("No root directory, go with relative " + relative);
            sourceDirectory = new File(relative);
            if (!sourceDirectory.isDirectory()) {
                throw new SearchException("Unable to read source directory: " + relative);
            }
        } else {
            File rootDir = new File(root);
            DirectoryProviderHelper.makeSanityCheckedDirectory(rootDir, directoryProviderName, needWritePermissions);
            sourceDirectory = new File(root, relative);
            DirectoryProviderHelper.makeSanityCheckedDirectory(sourceDirectory, directoryProviderName, needWritePermissions);
            log.debug("Got directory from root + relative");
        }
        return sourceDirectory;
    }

    public static FSDirectory createFSIndex(File indexDir) throws IOException {
        FSDirectory fsDirectory = FSDirectory.getDirectory(indexDir);
        if (!IndexReader.indexExists(fsDirectory)) {
            log.debug("Initialize index: '{}'", (Object)indexDir.getAbsolutePath());
            IndexWriter.MaxFieldLength fieldLength = new IndexWriter.MaxFieldLength(10000);
            IndexWriter iw = new IndexWriter((Directory)fsDirectory, (Analyzer)new StandardAnalyzer(), true, fieldLength);
            iw.close();
        }
        return fsDirectory;
    }

    public static File getVerifiedIndexDir(String annotatedIndexName, Properties properties, boolean verifyIsWritable) {
        String indexBase = properties.getProperty("indexBase", ".");
        String indexName = properties.getProperty("indexName", annotatedIndexName);
        File baseIndexDir = new File(indexBase);
        DirectoryProviderHelper.makeSanityCheckedDirectory(baseIndexDir, indexName, verifyIsWritable);
        File indexDir = new File(baseIndexDir, indexName);
        DirectoryProviderHelper.makeSanityCheckedDirectory(indexDir, indexName, verifyIsWritable);
        return indexDir;
    }

    private static void makeSanityCheckedDirectory(File directory, String indexName, boolean verifyIsWritable) {
        if (!directory.exists()) {
            log.warn("Index directory not found, creating: '" + directory.getAbsolutePath() + "'");
            if (!directory.mkdirs()) {
                throw new SearchException("Unable to create index directory: " + directory.getAbsolutePath() + " for index " + indexName);
            }
        } else if (!directory.isDirectory()) {
            throw new SearchException("Unable to initialize index: " + indexName + ": " + directory.getAbsolutePath() + " is a file.");
        }
        if (verifyIsWritable && !directory.canWrite()) {
            throw new SearchException("Cannot write into index directory: " + directory.getAbsolutePath() + " for index " + indexName);
        }
    }

    static long getRefreshPeriod(Properties properties, String directoryProviderName) {
        long period;
        String refreshPeriod = properties.getProperty("refresh", "3600");
        try {
            period = Long.parseLong(refreshPeriod);
        }
        catch (NumberFormatException nfe) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName + "; refresh period is not numeric.", nfe);
        }
        log.debug("Refresh period: {} seconds", period);
        return period * 1000L;
    }

    public static long getCopyBufferSize(String directoryProviderName, Properties properties) {
        String value = properties.getProperty(COPYBUFFERSIZE_PROP_NAME);
        long size = 0x1000000L;
        if (value != null) {
            try {
                size = Long.parseLong(value) * 1024L * 1024L;
            }
            catch (NumberFormatException nfe) {
                throw new SearchException("Unable to initialize index " + directoryProviderName + "; " + COPYBUFFERSIZE_PROP_NAME + " is not numeric.", nfe);
            }
            if (size <= 0L) {
                throw new SearchException("Unable to initialize index " + directoryProviderName + "; " + COPYBUFFERSIZE_PROP_NAME + " needs to be greater than zero.");
            }
        }
        return size;
    }
}

