/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.parser.xni;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.impl.dtd.XMLDTDValidatorFilter;
import org.apache.xerces.impl.xs.JBossXBSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.IntegratedParserConfiguration;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.AttributesImpl;
import org.jboss.xml.binding.JBossXBException;
import org.jboss.xml.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XniJBossXBParser
implements JBossXBParser {
    private static final Logger log = Logger.getLogger(XniJBossXBParser.class);
    private final XMLParserConfiguration config = new ParserConfiguration();
    private final DocumentParser parser = new DocumentParser(this.config);
    private JBossXBParser.ContentHandler contentHandler;

    public XniJBossXBParser() {
        this.config.setErrorHandler(new XMLErrorHandler(){

            public void warning(String domain, String key, XMLParseException exception) throws XNIException {
                log.warn("domain=" + domain + ", key=" + key + ": " + exception.getMessage());
            }

            public void error(String domain, String key, XMLParseException exception) throws XNIException {
                log.error("domain=" + domain + ", key=" + key + ": " + exception.getMessage());
                throw exception;
            }

            public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
                log.error("domain=" + domain + ", key=" + key + ": " + exception.getMessage());
                throw exception;
            }
        });
        this.config.setFeature("http://xml.org/sax/features/namespaces", true);
        this.config.setFeature("http://xml.org/sax/features/validation", true);
        this.config.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.config.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.config.setFeature("http://apache.org/xml/features/validation/dynamic", true);
    }

    public void setEntityResolver(final EntityResolver entityResolver) throws JBossXBException {
        this.config.setEntityResolver(new XMLEntityResolver(){
            private EntityResolver resolver;
            {
                this.resolver = entityResolver;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public XMLInputSource resolveEntity(XMLResourceIdentifier resId) throws XNIException, IOException {
                try {
                    InputSource source = this.resolver.resolveEntity(resId.getPublicId(), resId.getExpandedSystemId());
                    if (source == null) return null;
                    if (source.getCharacterStream() != null) {
                        return new XMLInputSource(resId.getPublicId(), resId.getExpandedSystemId(), resId.getBaseSystemId(), source.getCharacterStream(), source.getEncoding());
                    }
                    if (source.getByteStream() != null) {
                        return new XMLInputSource(resId.getPublicId(), resId.getExpandedSystemId(), resId.getBaseSystemId(), source.getByteStream(), source.getEncoding());
                    }
                    if (source.getSystemId() == null) throw new IllegalStateException("Resolved source contains no about the source, i.e. systemId, byte stream and character stream are all null.");
                    return new XMLInputSource(resId.getPublicId(), source.getSystemId(), resId.getBaseSystemId());
                }
                catch (SAXException e) {
                    throw new XNIException("Failed to resolve entity: publicId=" + resId.getPublicId() + ", literal systemId=" + resId.getLiteralSystemId() + ", base systemId=" + resId.getBaseSystemId() + ", expanded systemId=" + resId.getExpandedSystemId());
                }
            }
        });
    }

    public void setProperty(String name, Object value) throws JBossXBException {
        this.config.setProperty(name, value);
    }

    public void setFeature(String name, boolean value) throws JBossXBException {
        this.config.setFeature(name, value);
    }

    public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        XMLInputSource xmlSource = new XMLInputSource(null, systemId, null);
        try {
            this.parser.parse(xmlSource);
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse document " + systemId, e);
        }
    }

    public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        XMLInputSource xmlSource = new XMLInputSource(null, null, null, is, null);
        try {
            this.parser.parse(xmlSource);
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse document", e);
        }
    }

    public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        XMLInputSource xmlSource = new XMLInputSource(null, null, null, reader, null);
        try {
            this.parser.parse(xmlSource);
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse document", e);
        }
    }

    private static class SAXAttributes
    implements Attributes {
        private XMLAttributes attrs;

        private SAXAttributes() {
        }

        public void setAttrs(XMLAttributes attrs) {
            this.attrs = attrs;
        }

        public int getLength() {
            return this.attrs.getLength();
        }

        public String getLocalName(int index) {
            return this.attrs.getLocalName(index);
        }

        public String getQName(int index) {
            return this.attrs.getQName(index);
        }

        public String getType(int index) {
            return this.attrs.getType(index);
        }

        public String getURI(int index) {
            return this.attrs.getURI(index);
        }

        public String getValue(int index) {
            return this.attrs.getValue(index);
        }

        public int getIndex(String qName) {
            return this.attrs.getIndex(qName);
        }

        public String getType(String qName) {
            return this.attrs.getType(qName);
        }

        public String getValue(String qName) {
            return this.attrs.getValue(qName);
        }

        public int getIndex(String uri, String localName) {
            return this.attrs.getIndex(uri, localName);
        }

        public String getType(String uri, String localName) {
            return this.attrs.getType(uri, localName);
        }

        public String getValue(String uri, String localName) {
            return this.attrs.getValue(uri, localName);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            for (int i = 0; i < this.getLength(); ++i) {
                buffer.append(this.getLocalName(i));
                buffer.append('=');
                buffer.append(this.getValue(i));
                if (i >= this.getLength() - 1) continue;
                buffer.append(", ");
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    class ParserConfiguration
    extends IntegratedParserConfiguration {
        public ParserConfiguration() {
        }

        public ParserConfiguration(SymbolTable symbolTable) {
            super(symbolTable);
        }

        public ParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
            super(symbolTable, grammarPool);
        }

        public ParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
            super(symbolTable, grammarPool, parentSettings);
        }

        protected void configurePipeline() {
            this.setProperty("http://apache.org/xml/properties/internal/datatype-validator-factory", this.fDatatypeValidatorFactory);
            this.configureDTDPipeline();
            if (this.fFeatures.get("http://xml.org/sax/features/namespaces") == Boolean.TRUE) {
                this.fProperties.put("http://apache.org/xml/properties/internal/namespace-binder", this.fNamespaceBinder);
                this.fScanner = this.fNamespaceScanner;
                this.fProperties.put("http://apache.org/xml/properties/internal/document-scanner", this.fNamespaceScanner);
                if (this.fDTDValidator != null) {
                    this.fProperties.put("http://apache.org/xml/properties/internal/validator/dtd", this.fDTDValidator);
                    this.fNamespaceScanner.setDTDValidator((XMLDTDValidatorFilter)this.fDTDValidator);
                    this.fNamespaceScanner.setDocumentHandler((XMLDocumentHandler)this.fDTDValidator);
                    this.fDTDValidator.setDocumentSource((XMLDocumentSource)this.fNamespaceScanner);
                    this.fDTDValidator.setDocumentHandler(this.fDocumentHandler);
                    if (this.fDocumentHandler != null) {
                        this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fDTDValidator);
                    }
                    this.fLastComponent = this.fDTDValidator;
                } else {
                    this.fNamespaceScanner.setDocumentHandler(this.fDocumentHandler);
                    this.fNamespaceScanner.setDTDValidator(null);
                    if (this.fDocumentHandler != null) {
                        this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fNamespaceScanner);
                    }
                    this.fLastComponent = this.fNamespaceScanner;
                }
            } else {
                this.fScanner = this.fNonNSScanner;
                this.fProperties.put("http://apache.org/xml/properties/internal/document-scanner", this.fNonNSScanner);
                if (this.fNonNSDTDValidator != null) {
                    this.fProperties.put("http://apache.org/xml/properties/internal/validator/dtd", this.fNonNSDTDValidator);
                    this.fNonNSScanner.setDocumentHandler((XMLDocumentHandler)this.fNonNSDTDValidator);
                    this.fNonNSDTDValidator.setDocumentSource((XMLDocumentSource)this.fNonNSScanner);
                    this.fNonNSDTDValidator.setDocumentHandler(this.fDocumentHandler);
                    if (this.fDocumentHandler != null) {
                        this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fNonNSDTDValidator);
                    }
                    this.fLastComponent = this.fNonNSDTDValidator;
                } else {
                    this.fScanner.setDocumentHandler(this.fDocumentHandler);
                    if (this.fDocumentHandler != null) {
                        this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fScanner);
                    }
                    this.fLastComponent = this.fScanner;
                }
            }
            if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
                if (this.fSchemaValidator == null) {
                    this.fSchemaValidator = new JBossXBSchemaValidator();
                    this.fProperties.put("http://apache.org/xml/properties/internal/validator/schema", this.fSchemaValidator);
                    this.addComponent((XMLComponent)this.fSchemaValidator);
                    if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                        XSMessageFormatter xmft = new XSMessageFormatter();
                        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)xmft);
                    }
                }
                this.fLastComponent.setDocumentHandler((XMLDocumentHandler)this.fSchemaValidator);
                this.fSchemaValidator.setDocumentSource(this.fLastComponent);
                this.fSchemaValidator.setDocumentHandler(this.fDocumentHandler);
                if (this.fDocumentHandler != null) {
                    this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fSchemaValidator);
                }
                this.fLastComponent = this.fSchemaValidator;
            }
        }
    }

    class DocumentParser
    extends XMLDocumentParser {
        private boolean namespaces;
        private boolean prefixes;
        private NamespaceContext namespaceContext;
        private QName qName;
        private SAXAttributes saxAttrs;

        public DocumentParser(XMLParserConfiguration config) {
            super(config);
            this.qName = new QName();
            this.saxAttrs = new SAXAttributes();
            this.namespaces = config.getFeature("http://xml.org/sax/features/namespaces");
            this.prefixes = false;
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.namespaceContext = namespaceContext;
        }

        public void xmlDecl(String version2, String encoding, String standalone, Augmentations augs) throws XNIException {
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
        }

        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        }

        public void startElement(QName name, XMLAttributes attributes, Augmentations augs) throws XNIException {
            int count;
            JBossXBSchemaValidator validator;
            XSTypeDefinition type = null;
            if (augs != null && (validator = (JBossXBSchemaValidator)((Object)augs.getItem("jbossxb.validator"))) != null) {
                XSElementDeclaration element = validator.getCurrentElementDelcaration();
                type = element.getTypeDefinition();
            }
            if (type == null && log.isTraceEnabled()) {
                log.trace("Type is not available for " + name.rawname);
            }
            if (this.namespaces && (count = this.startNamespaceMapping()) > 0) {
                int len = attributes.getLength();
                for (int i = len - 1; i >= 0; --i) {
                    attributes.getName(i, this.qName);
                    if ((this.qName.prefix == null || !this.qName.prefix.equals("xmlns")) && !this.qName.rawname.equals("xmlns")) continue;
                    if (!this.prefixes) {
                        attributes.removeAttributeAt(i);
                        continue;
                    }
                    this.qName.prefix = "";
                    this.qName.uri = "";
                    this.qName.localpart = "";
                    attributes.setName(i, this.qName);
                }
            }
            String uri = name.uri != null ? name.uri : "";
            String localpart = this.namespaces ? name.localpart : "";
            this.saxAttrs.setAttrs(attributes);
            XniJBossXBParser.this.contentHandler.startElement(uri, localpart, name.rawname, this.saxAttrs, type);
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        }

        public void textDecl(String version2, String encoding, Augmentations augs) throws XNIException {
        }

        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            int i = text.offset;
            while (i < text.offset + text.length) {
                if (Character.isWhitespace(text.ch[i++])) continue;
                XniJBossXBParser.this.contentHandler.characters(text.ch, text.offset, text.length);
                break;
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            String uri = element.uri != null ? element.uri : "";
            String localpart = this.namespaces ? element.localpart : "";
            XniJBossXBParser.this.contentHandler.endElement(uri, localpart, element.rawname);
        }

        public void startCDATA(Augmentations augs) throws XNIException {
        }

        public void endCDATA(Augmentations augs) throws XNIException {
        }

        public void endDocument(Augmentations augs) throws XNIException {
            super.endDocument(augs);
        }

        protected final int startNamespaceMapping() {
            int count = this.namespaceContext.getDeclaredPrefixCount();
            if (count > 0) {
                String prefix = null;
                String uri = null;
                for (int i = 0; i < count; ++i) {
                    prefix = this.namespaceContext.getDeclaredPrefixAt(i);
                    uri = this.namespaceContext.getURI(prefix);
                    XniJBossXBParser.this.contentHandler.startPrefixMapping(prefix, uri == null ? "" : uri);
                }
            }
            return count;
        }

        private AttributesImpl toSaxAttributes(XMLAttributes attributes) {
            AttributesImpl attrs = null;
            if (attributes != null) {
                attrs = new AttributesImpl(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if ("xmlns".equals(attributes.getPrefix(i))) continue;
                    attrs.add(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                }
            }
            return attrs;
        }
    }
}

