/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundReceiver;
import org.objectweb.joram.client.connector.OutboundSender;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundQueueSession
extends OutboundSession
implements QueueSession {
    OutboundQueueSession(Session sess, OutboundConnection cnx) {
        super(sess, cnx);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundQueueSession(" + sess + ", " + cnx + ")"));
        }
    }

    OutboundQueueSession(Session sess, OutboundConnection cnx, boolean transacted) {
        super(sess, cnx, transacted);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundQueueSession(" + sess + ", " + cnx + ")"));
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createSender(" + queue + ")"));
        }
        this.checkValidity();
        return new OutboundSender(this.sess.createProducer(queue), this);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createReceiver(" + queue + ", " + selector + ")"));
        }
        this.checkValidity();
        return new OutboundReceiver(queue, this.sess.createConsumer(queue, selector), this);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createReceiver(" + queue + ")"));
        }
        this.checkValidity();
        return new OutboundReceiver(queue, this.sess.createConsumer(queue), this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Forbidden call on a OutboundQueueSession.");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Forbidden call on a OutboundQueueSession.");
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Forbidden call on a OutboundQueueSession.");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Forbidden call on a OutboundQueueSession.");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException("Forbidden call on a OutboundQueueSession.");
    }

    public String toString() {
        if (this.sess != null) {
            return this.sess.toString();
        }
        return null;
    }
}

