/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.velocity.VelocityContext;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.api.MOP;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.util.monolog.api.BasicLevel;

public class AbstractMappingGenerator
extends CommonGenerator {
    protected HashMap mmops = new HashMap();

    public AbstractMappingGenerator(JormCompilerConfigurator jcc, JormCompilerParameter cp) throws PException {
        Iterator it = jcc.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.mmops.put(mn, jcc.getMOPFactory(mn).createMappingMOP(cp, mn));
        }
    }

    public String[][] getTemplateLibraries() {
        String[][] res = new String[this.mmops.size()][];
        Iterator it = this.mmops.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            res[i] = ((MOP)it.next()).getTemplateLibraries();
            ++i;
        }
        return res;
    }

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp, JormCompilerConfigurator jcc) throws PException {
        if (!clazz.isAbstract()) {
            return;
        }
        Collection nds = clazz.getNameDefs();
        Class classWithNd = clazz;
        while (nds.size() < 1 && classWithNd.getInheritedClassNumber() > 0) {
            classWithNd = (Class)classWithNd.getSuperClasses().iterator().next();
            nds = classWithNd.getNameDefs();
        }
        if (nds.size() < 1) {
            this.logger.log(BasicLevel.WARN, (Object)("AbstractMapping: No NameDef defined for the class " + clazz.getFQName()));
            return;
        }
        if (nds.size() == 1) {
            this.generate(clazz, holder, cp, (NameDef)nds.iterator().next(), null);
        } else {
            Iterator it = nds.iterator();
            while (it.hasNext()) {
                NameDef nd;
                this.generate(clazz, holder, cp, nd, (String)((nd = (NameDef)it.next()).getName() != null && nd.getName().length() == 0 ? null : nd.getName()));
            }
        }
    }

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp, NameDef nd, String ndName) throws PException {
        Collection ms;
        String packName = ((Package)clazz.getParent()).getName();
        String fileName = clazz.getName() + "Mapping";
        if (ndName != null) {
            packName = packName != null && packName.length() > 0 ? packName + "." + ndName : ndName;
        }
        if (packName.length() > 0) {
            fileName = (packName + '.').replace('.', File.separatorChar) + fileName;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate the " + fileName + " class"));
        VelocityContext ctx = new VelocityContext();
        ctx.put("class", clazz);
        if (packName.length() > 0) {
            ctx.put("package", packName);
        }
        ctx.put("cparam", cp);
        CommonHelper ch = new CommonHelper();
        ch.setLogger(this.logger);
        ctx.put("tools", ch);
        ctx.put("mappername", "");
        ctx.put("noBindingCreation", Boolean.TRUE);
        ctx.put("abstractMapping", Boolean.TRUE);
        ctx.put("header", "org/objectweb/jorm/generator/lib/Header.vm");
        ctx.put("mappingTools", this);
        ClassProject classproject = clazz.getClassProject(cp.getProjectName());
        ArrayList dependencies = new ArrayList();
        if (classproject != null && !(ms = classproject.getMappings()).isEmpty()) {
            Iterator it = ms.iterator();
            while (it.hasNext()) {
                Mapping m = (Mapping)it.next();
                ClassMapping cm = m.getClassMapping();
                if (cm == null) continue;
                dependencies.addAll(cm.getDependencies());
            }
        }
        ctx.put("dependencies", dependencies);
        try {
            FileWriter fw = holder.getFileWriter(fileName + ".java");
            this.velocityEngine.getTemplate("org/objectweb/jorm/generator/lib/Mapping.vm").merge(ctx, fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while writing Mapping java file: " + fileName + ".java");
        }
    }
}

