/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.util.HashMap;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbFilter
extends BasicMetaObject {
    HashMap filteringElements = new HashMap();
    private String stringExp = null;
    private Expression exp = null;

    public RdbFilter(MetaObject parent) {
        super(parent);
    }

    public boolean isFilter(PrimitiveElement pe) {
        this.logger.log(BasicLevel.DEBUG, (Object)("Looking whether PrimitiveElement " + pe.getName() + " is in the filter"));
        return this.filteringElements.containsKey(pe.getName());
    }

    public String getEqualPredicateValue(String elementName) throws PException {
        String predValue = (String)this.filteringElements.get(elementName);
        if (predValue == null) {
            throw new PException("No fixed value can be given for this PrimitiveElement " + elementName + " although it is a hidden filter field!");
        }
        return predValue;
    }

    public void setExpression(Expression e) {
        this.exp = e;
        this.addElementsToFilter(e);
    }

    private void addElementsToFilter(Expression e) {
        if (e instanceof BasicParameterOperand) {
            this.filteringElements.put(((BasicParameterOperand)e).getName(), null);
        } else if (!(e instanceof Operand)) {
            if (e instanceof Equal) {
                Equal eq = (Equal)e;
                Expression eq0 = eq.getExpression(0);
                Expression eq1 = eq.getExpression(1);
                if (eq0 instanceof BasicParameterOperand) {
                    if (eq1 instanceof BasicOperand) {
                        this.filteringElements.put(((BasicParameterOperand)eq0).getName(), ((BasicOperand)eq1).getObject());
                    } else {
                        this.filteringElements.put(((BasicParameterOperand)eq0).getName(), null);
                        this.addElementsToFilter(eq1);
                    }
                } else if (eq1 instanceof BasicParameterOperand) {
                    if (eq0 instanceof BasicOperand) {
                        this.filteringElements.put(((BasicParameterOperand)eq1).getName(), ((BasicOperand)eq0).getObject());
                    } else {
                        this.filteringElements.put(((BasicParameterOperand)eq1).getName(), null);
                        this.addElementsToFilter(eq0);
                    }
                } else {
                    this.addElementsToFilter(eq.getExpression(0));
                    this.addElementsToFilter(eq.getExpression(1));
                }
            } else if (e instanceof Operator) {
                Operator op = (Operator)e;
                for (int i = 0; i < op.getOperandNumber(); ++i) {
                    this.addElementsToFilter(op.getExpression(i));
                }
            }
        }
    }

    public Expression getExpression() {
        return this.exp;
    }

    public void setStringExpression(String e) {
        this.stringExp = e;
    }

    public String getStringExpression() {
        return this.stringExp;
    }
}

