/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.lib.JormCompiler;
import org.objectweb.jorm.compiler.lib.JormCompilerConfiguratorImpl;
import org.objectweb.jorm.compiler.lib.JormCompilerParameterImpl;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;

public class AntJorm
extends MatchingTask {
    private String jormConfFile = "jorm.properties";
    private File pdDir = null;
    private boolean antDtdLocationsSet = false;
    private ArrayList antDtdLocations = new ArrayList();
    private boolean antJavacSet = false;
    private boolean antJavac;
    private boolean classpathSet = false;
    private PathExplorer classpath = new DirJavaExplorer();
    private boolean antOutputSet = false;
    private String antOutput;
    private boolean antLogConfFileSet = false;
    private String antLogConfFile;
    private boolean antProjectNameSet = false;
    private String antProjectName;
    private boolean antBindingInheritanceSet = false;
    private String antBindingInheritance;
    private boolean antClassMappingInheritanceSet = false;
    private String antClassMappingInheritance;
    private boolean antVerboseSet = false;
    private boolean antVerbose;
    private boolean antKeepSrcSet = false;
    private boolean antKeepSrc;
    private boolean antBindingAbstractSet = false;
    private boolean antBindingAbstract;
    private boolean generatedPDFiles = false;
    private String mapperNames = null;
    private JormCompilerParameter compilerParameter = new JormCompilerParameterImpl();
    private JormCompilerConfigurator compilerConfigurator = new JormCompilerConfiguratorImpl();
    private JormCompiler compiler = new JormCompiler(this.compilerParameter, this.compilerConfigurator);

    public void setPdDir(File d) {
        this.pdDir = d;
        this.classpath.addPath(d.getAbsolutePath());
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.antDtdLocations.add(dtdLocation);
        this.antDtdLocationsSet = true;
        return dtdLocation;
    }

    public void setJavac(boolean l) {
        this.antJavac = l;
        this.antJavacSet = true;
    }

    public void setMapperNames(String mapperNames) {
        if (mapperNames != null && mapperNames.length() > 0) {
            this.mapperNames = mapperNames;
        }
    }

    public void setOtherPdFiles(Path cp) {
        String[] dl = cp.list();
        for (int i = 0; i < dl.length; ++i) {
            this.classpath.addPath(dl[i]);
            this.classpathSet = true;
        }
    }

    public void setOtherPdFilesRef(Reference r) {
        Path p = new Path(this.getProject());
        p.setRefid(r);
        this.setOtherPdFiles(p);
    }

    public void setOutput(String s) {
        this.antOutput = s;
        this.antOutputSet = true;
    }

    public void setJormConf(String s) {
        this.jormConfFile = s;
    }

    public void setLogConf(String s) {
        this.antLogConfFile = s;
        this.antLogConfFileSet = true;
    }

    public void setProjectName(String s) {
        this.antProjectName = s;
        this.antProjectNameSet = true;
    }

    public void setBindingInheritance(String s) {
        this.antBindingInheritance = s;
        this.antBindingInheritanceSet = true;
    }

    public void setMappingInheritance(String s) {
        this.antClassMappingInheritance = s;
        this.antClassMappingInheritanceSet = true;
    }

    public void setVerbose(boolean verbose) {
        this.antVerbose = verbose;
        this.antVerboseSet = true;
    }

    public void setKeepsrc(boolean keepsrc) {
        this.antKeepSrc = keepsrc;
        this.antKeepSrcSet = true;
    }

    public void setBindingAbstract(boolean bindingAbstract) {
        this.antBindingAbstract = bindingAbstract;
        this.antBindingAbstractSet = true;
    }

    public void setGeneratePDFiles(boolean val) {
        this.generatedPDFiles = val;
    }

    public void execute() throws BuildException {
        try {
            this.compilerConfigurator.configure(this.jormConfFile);
            if (!this.antLogConfFileSet) {
                this.compilerConfigurator.configureLog(this.jormConfFile);
            } else {
                this.compilerConfigurator.configureLog(this.antLogConfFile);
            }
            if (this.mapperNames != null) {
                StringTokenizer st = new StringTokenizer(this.mapperNames.trim(), ".,", true);
                if (st.hasMoreTokens()) {
                    this.compilerConfigurator.removeAllMappers();
                }
                while (st.hasMoreTokens()) {
                    String mn = st.nextToken();
                    if (mn.equals(".") || mn.equals(",")) {
                        String errmsg = "Malformed mapperNames string (expect mapper name): " + this.mapperNames;
                        this.log(errmsg, 0);
                        throw new BuildException(errmsg);
                    }
                    if (!st.hasMoreTokens()) {
                        String errmsg = "Malformed mapperNames string (expect \".\"): " + this.mapperNames;
                        this.log(errmsg, 0);
                        throw new BuildException(errmsg);
                    }
                    String smn = st.nextToken();
                    if (!smn.equals(".")) {
                        String errmsg = "Malformed mapperNames string (expect \".\"): " + this.mapperNames;
                        this.log(errmsg, 0);
                        throw new BuildException(errmsg);
                    }
                    if (!st.hasMoreTokens()) {
                        String errmsg = "Malformed mapperNames string (expect submapper name): " + this.mapperNames;
                        this.log(errmsg, 0);
                        throw new BuildException(errmsg);
                    }
                    smn = st.nextToken();
                    this.compilerConfigurator.addSubMapper(mn, smn);
                    if (!st.hasMoreTokens() || (smn = st.nextToken()).equals(",")) continue;
                    String errmsg = "Malformed mapperNames string (expect \",\"): " + this.mapperNames;
                    this.log(errmsg, 0);
                    throw new BuildException(errmsg);
                }
            }
            this.compilerParameter.loadConfFile(this.compilerConfigurator.getGlobalJormcOptsFile(), this.compilerConfigurator.knownMappers());
            if (this.antDtdLocationsSet) {
                this.compilerParameter.setDtdLocations(this.antDtdLocations);
            }
            if (this.antJavacSet) {
                this.compilerParameter.setJavac(this.antJavac);
            }
            if (this.classpathSet) {
                this.compilerParameter.setClasspath(this.classpath);
            }
            if (this.antOutputSet) {
                this.compilerParameter.setOutput(this.antOutput);
            }
            if (this.antLogConfFileSet) {
                this.compilerParameter.setLogConfFile(this.antLogConfFile);
            }
            if (this.antProjectNameSet) {
                this.compilerParameter.setProjectName(this.antProjectName);
            }
            if (this.antBindingInheritanceSet) {
                this.compilerParameter.setBindingInheritance(this.antBindingInheritance);
            }
            if (this.antClassMappingInheritanceSet) {
                this.compilerParameter.setClassMappingInheritance(this.antClassMappingInheritance);
            }
            if (this.antVerboseSet) {
                this.compilerParameter.setVerbose(this.antVerbose);
            }
            if (this.antKeepSrcSet) {
                this.compilerParameter.setKeepSrc(this.antKeepSrc);
            }
            if (this.antBindingAbstractSet) {
                this.compilerParameter.setBindingAbstract(this.antBindingAbstract);
            }
            this.compilerParameter.setGeneratedPDFiles(this.generatedPDFiles);
        }
        catch (PException e) {
            Exception current = e;
            while (current instanceof PException && current.getNestedException() != null) {
                current = current.getNestedException();
            }
            throw new BuildException(current);
        }
        this.log("Assigns immutable properties", 4);
        this.log("pdDir=" + this.pdDir, 4);
        String[] pdFiles = super.getDirectoryScanner(this.pdDir).getIncludedFiles();
        this.log("Generates(" + pdFiles + ")", 4);
        this.generates(pdFiles);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generates(String[] pdFileNames) throws BuildException {
        ArrayList<String> compileList = new ArrayList<String>();
        for (int i = 0; i < pdFileNames.length; ++i) {
            boolean mustGenerate;
            String className;
            String packageName;
            int n = pdFileNames[i].lastIndexOf(File.separatorChar);
            if (n == -1) {
                packageName = null;
                className = pdFileNames[i];
            } else {
                packageName = pdFileNames[i].substring(0, n);
                className = pdFileNames[i].substring(n + 1);
            }
            className = className.substring(0, className.lastIndexOf(46));
            this.log("-packageName=" + packageName, 4);
            this.log("-className=" + className, 4);
            File pdFile = new File(this.pdDir, pdFileNames[i]);
            this.log("-pdfile=" + pdFile, 4);
            FileSet fs = new FileSet();
            fs.setProject(this.getProject());
            fs.setDir(this.pdDir);
            fs.setIncludes(pdFileNames[i]);
            UpToDate u = new UpToDate();
            u.setProject(this.getProject());
            u.addSrcfiles(fs);
            String pngFileName = this.compilerParameter.getOutput() + File.separator + (packageName == null ? "" : packageName + File.separator) + File.separator + className + "PNG.class";
            this.log("\tpngFileName=" + pngFileName, 4);
            String accFileName = this.compilerParameter.getOutput() + File.separator + (packageName == null ? "" : packageName + File.separator) + File.separator + className + "Accessor.class";
            this.log("\taccFileName=" + accFileName, 4);
            File pngFile = new File(pngFileName);
            File accFile = new File(accFileName);
            if (accFile.exists()) {
                u.setTargetFile(accFile);
                mustGenerate = !u.eval();
            } else if (pngFile.exists()) {
                u.setTargetFile(pngFile);
                mustGenerate = !u.eval();
            } else {
                mustGenerate = true;
            }
            if (!mustGenerate) continue;
            compileList.add(pdFileNames[i]);
        }
        if (compileList.size() > 0) {
            this.log("not upToDate", 4);
            this.compilerParameter.setInputFiles(compileList);
            try {
                boolean javac = this.compilerParameter.isJavac();
                this.compilerParameter.setJavac(false);
                this.compiler.process();
                if (!javac) return;
                this.log("javac compilation", 4);
                Javac javac2 = new Javac();
                Path path = new Path(this.getProject(), this.compilerParameter.getOutput());
                javac2.setProject(this.getProject());
                javac2.setSrcdir(path);
                javac2.setDestdir(new File(this.compilerParameter.getOutput()));
                javac2.setDebug(true);
                javac2.setIncludes("**/*.java");
                javac2.execute();
                return;
            }
            catch (PException e) {
                void var4_8;
                PException pException = e;
                while (var4_8 instanceof PException && ((PException)var4_8).getNestedException() != null) {
                    Exception exception = ((PException)var4_8).getNestedException();
                }
                var4_8.printStackTrace();
                throw new BuildException((Throwable)var4_8);
            }
        } else {
            this.log("upToDate", 4);
        }
    }
}

