/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.UnsupportedExtensionException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class SAMLQuery
extends SAMLObject
implements Cloneable {
    protected static Hashtable queryTypeMap = new Hashtable();

    public static void regFactory(QName qName, String string) {
        queryTypeMap.put(qName, string);
    }

    public static void unregFactory(QName qName) {
        queryTypeMap.remove(qName);
    }

    public static SAMLQuery getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLQuery.getInstance() given an empty DOM");
        }
        try {
            if (XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Query") || XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectQuery")) {
                String string = (String)queryTypeMap.get(QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type"));
                if (string == null) {
                    throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLQuery.getInstance() unable to locate an implementation of specified query type");
                }
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Element")};
                Object[] objectArray = new Object[]{element};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                return (SAMLQuery)constructor.newInstance(objectArray);
            }
            String string = (String)queryTypeMap.get(new QName(element.getNamespaceURI(), element.getLocalName()));
            if (string == null) {
                throw new UnsupportedExtensionException(SAMLException.RESPONDER, "SAMLQuery.getInstance() unable to locate an implementation of specified query type");
            }
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Element")};
            Object[] objectArray = new Object[]{element};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLQuery)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLQuery.getInstance() unable to locate implementation class for query", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLQuery.getInstance() unable to bind to constructor for query", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLQuery.getInstance() unable to build implementation object for query", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLQuery.getInstance() unable to access implementation of query", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLQuery.getInstance() caught unknown exception while building query object: " + throwable.getMessage());
        }
    }

    public static SAMLQuery getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLQuery.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLQuery").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLQuery.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLQuery").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLQuery.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }
}

