/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.cmi.controller.client.ClientClusteredObjectView;
import org.ow2.cmi.controller.common.ImmutableClusteredObjectInfos;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.reference.ServerRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class ClientClusterViewCache {
    private Map<String, ClientClusteredObjectView> objects = new ConcurrentHashMap<String, ClientClusteredObjectView>();
    private Map<ServerRef, Integer> loadFactors = new ConcurrentHashMap<ServerRef, Integer>();
    private Map<String, Class<? extends IPolicy<?>>> policyClasses = new HashMap();
    private Map<String, Class<? extends IStrategy<?>>> strategyClasses = new HashMap();

    public ClientClusteredObjectView addClusteredObject(ImmutableClusteredObjectInfos immutableInfos) {
        return this.addClusteredObject(immutableInfos.getClusterName(), immutableInfos.isProxyEnabled(), immutableInfos.getObjectName(), immutableInfos.getItfName(), immutableInfos.getBusinessName(), immutableInfos.isStateful(), immutableInfos.getApplicationExceptionNames());
    }

    public ClientClusteredObjectView addClusteredObject(String clusterName, boolean proxyEnabled, String objectName, String itfName, String businessName, boolean stateful, Set<String> applicationExceptionNames) {
        ClientClusteredObjectView clusteredObjectView = this.objects.get(objectName);
        if (clusteredObjectView == null) {
            clusteredObjectView = new ClientClusteredObjectView(clusterName, proxyEnabled, objectName, itfName, businessName, stateful, applicationExceptionNames);
            this.objects.put(objectName, clusteredObjectView);
        }
        return clusteredObjectView;
    }

    public ClientClusteredObjectView getClusteredObject(String objectName) {
        return this.objects.get(objectName);
    }

    int getLoadFactor(ServerRef serverRef) {
        return this.loadFactors.get(serverRef);
    }

    void setLoadFactor(ServerRef serverRef, int loadFactor) {
        this.loadFactors.put(serverRef, loadFactor);
    }

    Set<ServerRef> getAddressesOfServer() {
        return this.loadFactors.keySet();
    }

    public void removeLoadFactor(ServerRef address) {
        this.loadFactors.remove(address);
    }

    public void clear() {
        this.objects.clear();
        this.loadFactors.clear();
    }

    public Set<String> getObjectNames() {
        return this.objects.keySet();
    }

    public void setPolicyClass(String policyClassname, Class<? extends IPolicy<?>> policyClass) {
        this.policyClasses.put(policyClassname, policyClass);
    }

    public void setStrategyClass(String strategyClassname, Class<? extends IStrategy<?>> strategyClass) {
        this.strategyClasses.put(strategyClassname, strategyClass);
    }

    public Class<? extends IPolicy<?>> getPolicyClass(String classname) {
        return this.policyClasses.get(classname);
    }

    public Class<? extends IStrategy<?>> getStrategyClass(String classname) {
        return this.strategyClasses.get(classname);
    }
}

