/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ejb2_1.pool;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.cmi.pool.NamingPoolException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.reference.serialization.RemoteIIOPCMIReferenceableWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBObjectFactory
implements PoolFactory<CMIReferenceable<?>, CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(EJBObjectFactory.class);
    private final ClusterViewManager clusterViewManager;

    public EJBObjectFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    /*
     * Loose catch block
     */
    @Override
    public CMIReferenceable<EJBObject> create(CMIReference cmiReference) throws PoolException {
        Object ejbObject;
        Method methodCreate;
        EJBHome ejbHome;
        Class<?> homeClass;
        String protocol;
        block19: {
            InitialContext chosenContext;
            ServerRef serverRef = cmiReference.getServerRef();
            protocol = serverRef.getProtocol();
            String bindName = cmiReference.getObjectName();
            try {
                homeClass = this.clusterViewManager.getInterface(bindName);
            }
            catch (Exception e) {
                LOGGER.error("Cannot get interface for name {0}", bindName, e);
                throw new PoolException("Cannot get interface for name " + bindName, e);
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            try {
                env.put("java.naming.factory.initial", this.clusterViewManager.getInitialContextFactoryName(protocol));
            }
            catch (ProtocolNotFoundException e) {
                LOGGER.error("Cannot get a class name for the initial context factory", e);
                throw new PoolException("Cannot get a class name for the initial context factory", e);
            }
            env.put("java.naming.provider.url", serverRef.getProviderURL());
            try {
                chosenContext = new InitialContext(env);
            }
            catch (NamingException e) {
                LOGGER.error("Cannot get a real context", e);
                throw new PoolException("Cannot get a real context", e);
            }
            ejbHome = null;
            LOGGER.debug("Lookup {0} on {1}", bindName, serverRef.getProviderURL());
            ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)chosenContext.lookup(bindName), homeClass);
            try {
                chosenContext.close();
            }
            catch (NamingException e) {
                LOGGER.debug("Unable to close the context", e);
            }
            break block19;
            catch (NamingException e) {
                try {
                    LOGGER.info("No ClientClusterViewProvider is bound with the name {0} at the url {1}", bindName, serverRef.getProviderURL(), e);
                    throw new NamingPoolException("No ClientClusterViewProvider is bound with the name " + bindName + " at the url " + serverRef.getProviderURL(), e);
                }
                catch (Throwable throwable) {
                    try {
                        chosenContext.close();
                    }
                    catch (NamingException e2) {
                        LOGGER.debug("Unable to close the context", e2);
                    }
                    throw throwable;
                }
            }
        }
        try {
            methodCreate = homeClass.getDeclaredMethod("create", new Class[0]);
        }
        catch (Exception e) {
            LOGGER.error("Cannot get method create for home class: " + homeClass.getName(), e);
            throw new EJBInvocationHandlerException("Cannot get method create for home class: " + homeClass.getName(), e);
        }
        try {
            ejbObject = methodCreate.invoke((Object)ejbHome, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Cannot invoke method create for ejb home: " + ejbHome, e);
            throw new EJBInvocationHandlerException("Cannot invoke method create for ejb home: " + ejbHome, e);
        }
        if (protocol.equals("iiop")) {
            return new RemoteIIOPCMIReferenceableWrapper<EJBObject>(cmiReference, (EJBObject)ejbObject);
        }
        return new CMIReferenceableWrapper<EJBObject>(cmiReference, (EJBObject)ejbObject);
    }

    @Override
    public boolean isMatching(CMIReferenceable<?> object, CMIReference clue) {
        LOGGER.debug("{0} == {1} ?", object.getReference(), clue);
        return object.getReference().equals(clue);
    }

    @Override
    public void remove(CMIReferenceable<?> object) {
    }

    @Override
    public boolean validate(CMIReferenceable<?> object, PoolEntryStatistics stats) {
        return true;
    }

    public void setClue(CMIReferenceable<?> cmiReferenceable, CMIReference cmiRef) throws PoolException {
        if (!(cmiReferenceable instanceof RemoteIIOPCMIReferenceableWrapper)) {
            throw new PoolException("Cannot set the given clue on the instance");
        }
        ((RemoteIIOPCMIReferenceableWrapper)cmiReferenceable).setReference(cmiRef);
    }
}

