/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.strategy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class LocalPreference<T extends LoadBalanceable>
implements IStrategy<T> {
    private static final Log LOGGER = LogFactory.getLog(LocalPreference.class);
    private final ClusterViewManager clusterViewManager;

    public LocalPreference(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public List<T> choose(Collection<T> cmiRefs) {
        ArrayList<LoadBalanceable> localServers = new ArrayList<LoadBalanceable>();
        for (LoadBalanceable cmiRef : cmiRefs) {
            ServerRef serverRef = cmiRef.getServerRef();
            InetAddress inetAddress = serverRef.getInetAddress();
            try {
                if (!this.isLocal(inetAddress)) continue;
                localServers.add(cmiRef);
            }
            catch (SocketException e) {
                LOGGER.error("Cannot know if is local or not", e);
                throw new RuntimeException("Cannot know if is local or not", e);
            }
        }
        return localServers;
    }

    private boolean isLocal(InetAddress inetAddress) throws SocketException {
        return this.clusterViewManager instanceof ClientClusterViewManager ? NetworkInterface.getByInetAddress(inetAddress) != null : this.clusterViewManager instanceof ServerClusterViewManager && inetAddress.equals(((ServerClusterViewManager)this.clusterViewManager).getInetAddress());
    }

    public String toString() {
        return "LocalPreference";
    }
}

