/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference.serialization;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.rmi.Remote;
import javax.naming.NamingException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.serialization.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIIOPCMIReferenceableWrapper<T extends Remote>
extends CMIReferenceableWrapper<T> {
    private static final long serialVersionUID = 1192398491336031370L;
    private String ior;

    public RemoteIIOPCMIReferenceableWrapper(CMIReference cmiRef, T referencedObject) {
        super(cmiRef, referencedObject);
    }

    public RemoteIIOPCMIReferenceableWrapper(CMIReference cmiRef, String ior) {
        super(cmiRef, null);
        this.ior = ior;
    }

    private Object readResolve() throws ObjectStreamException {
        Remote remote;
        CMIReference ref = this.getReference();
        try {
            remote = Utility.string_to_remote(this.ior);
        }
        catch (NamingException e) {
            throw new InvalidObjectException("Cannot get the stub from the ior " + this.ior);
        }
        return new RemoteIIOPCMIReferenceableWrapper<Remote>(ref, remote);
    }

    private Object writeReplace() throws ObjectStreamException {
        String ior;
        CMIReference ref = this.getReference();
        try {
            ior = Utility.remote_to_string((Remote)this.getReferencedObject());
        }
        catch (NamingException e) {
            throw new InvalidObjectException("Cannot get the ior from the stub " + this.getReferencedObject());
        }
        return new RemoteIIOPCMIReferenceableWrapper<T>(ref, ior);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

