/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.IStatefulSessionFactory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.ow2.easybeans.component.quartz.EasyBeansTimer;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzTimerService
implements TimerService {
    private Factory<?, ?> factory = null;
    private Scheduler scheduler = null;
    private String triggerGroupName = null;
    private long triggerId = 0L;
    private long jobDetailId = 0L;

    public QuartzTimerService(Factory<?, ?> factory, Scheduler scheduler) {
        this.factory = factory;
        this.scheduler = scheduler;
        this.triggerGroupName = factory.getId();
    }

    @Override
    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(duration, info) method cannot be called within the operation state '" + (Object)((Object)operationState) + "'.");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), info);
    }

    @Override
    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(duratinitialDurationion, intervalDuration, info)  method cannot be called within the operation state '" + (Object)((Object)operationState) + "'.");
        }
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createTimer(initialExpiration, intervalDuration, info);
    }

    @Override
    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(expiration, info) method cannot be called within the operation state '" + (Object)((Object)operationState) + "'.");
        }
        SimpleTrigger trigger = new SimpleTrigger(this.getTriggerName(), this.getTriggerGroupName(), expiration);
        return this.internalTimer(trigger, info);
    }

    @Override
    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The createTimer() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(initialExpiration, intervalDuration, info) method cannot be called within the operation state '" + (Object)((Object)operationState) + "'.");
        }
        SimpleTrigger trigger = new SimpleTrigger(this.getTriggerName(), this.getTriggerGroupName(), initialExpiration, null, SimpleTrigger.REPEAT_INDEFINITELY, intervalDuration);
        return this.internalTimer(trigger, info);
    }

    private Timer internalTimer(Trigger trigger, Serializable info) {
        EasyBeansJobDetailData beansJobDetailData = new EasyBeansJobDetailData();
        beansJobDetailData.setInfo(info);
        Integer easyBeansServerID = this.factory.getContainer().getConfiguration().getEZBServer().getID();
        beansJobDetailData.setEasyBeansServerID(easyBeansServerID);
        beansJobDetailData.setContainerId(this.factory.getContainer().getId());
        beansJobDetailData.setFactoryName(this.factory.getBeanInfo().getName());
        EasyBeansJobDetail jobDetail = new EasyBeansJobDetail(this.getNewJobDetailName(), this.getJobDetailGroupName(), beansJobDetailData);
        EasyBeansTimer timer = new EasyBeansTimer(jobDetail, trigger, this.scheduler, this.factory);
        beansJobDetailData.setTimer(timer);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot schedule the given job '" + jobDetail + "'.", e);
        }
        return timer;
    }

    @Override
    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        if (this.factory instanceof IStatefulSessionFactory) {
            throw new IllegalStateException("The getTimers() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.factory.getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The createTimer(duration, info) method cannot be called within the operation state '" + (Object)((Object)operationState) + "'.");
        }
        ArrayList<Timer> timers = new ArrayList<Timer>();
        String[] jobNames = null;
        try {
            jobNames = this.scheduler.getJobNames(this.getJobDetailGroupName());
        }
        catch (SchedulerException e) {
            throw new EJBException("Unable to get the job names from the scheduler for the group named '" + this.getJobDetailGroupName() + "'.", e);
        }
        if (jobNames != null) {
            for (String jobName : jobNames) {
                JobDetail jobDetail = null;
                try {
                    jobDetail = this.scheduler.getJobDetail(jobName, this.getJobDetailGroupName());
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get the jobDetail for the jobName '" + jobName + "'.", e);
                }
                EasyBeansJobDetail easyBeansJobDetail = null;
                if (!(jobDetail instanceof EasyBeansJobDetail)) {
                    throw new EJBException("JobDetail found for the job named '" + jobName + "' is not an EasyBeansJobDetail object");
                }
                easyBeansJobDetail = (EasyBeansJobDetail)jobDetail;
                Trigger[] triggers = null;
                try {
                    triggers = this.scheduler.getTriggersOfJob(jobName, this.getJobDetailGroupName());
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get triggers for the job named '" + jobName + "'.", e);
                }
                if (triggers == null || triggers.length > 1) {
                    throw new EJBException("Invalid numbers of triggers found for the job named '" + jobName + "'.");
                }
                timers.add(new EasyBeansTimer(easyBeansJobDetail, triggers[0], this.scheduler, this.factory));
            }
        }
        return timers;
    }

    private synchronized String getTriggerName() {
        return "triggerTimer" + this.triggerId++;
    }

    private synchronized String getNewJobDetailName() {
        return "jobDetail" + this.jobDetailId++;
    }

    private String getTriggerGroupName() {
        return this.triggerGroupName;
    }

    private String getJobDetailGroupName() {
        return "jobDetailGroup" + this.factory.getClassName();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

