/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.statistic;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.statistic.EZBStatisticProvider;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.statistic.ManagedStatistic;
import org.ow2.easybeans.component.statistic.ManagedStatisticFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedStatisticProvider {
    private static final boolean DEFAULT_STATISTIC_PROVIDER_STATE = true;
    private static final EZBStatisticComponent.STATISTIC_PROVIDER_MODE DEFAULT_STATISTIC_PROVIDER_MODE = EZBStatisticComponent.STATISTIC_PROVIDER_MODE.INHERIT;
    private EZBStatisticProvider statisticProvider;
    private ManagedStatisticProvider parentManagedStatisticProvider = null;
    private List<ManagedStatisticProvider> childManagedStatisticProviders = new LinkedList<ManagedStatisticProvider>();
    private List<ManagedStatistic> managedStatistics = new LinkedList<ManagedStatistic>();
    private boolean managedStatisticProviderState;
    private EZBStatisticComponent.STATISTIC_PROVIDER_MODE managedStatisticProviderMode;

    public ManagedStatisticProvider(EZBStatisticProvider statisticProvider, Map<String, ManagedStatisticProvider> managedStatisticProviders, Map<String, ManagedStatisticFactory> managedStatisticFactories) {
        this.statisticProvider = statisticProvider;
        for (ManagedStatisticProvider managedStatisticProvider : managedStatisticProviders.values()) {
            if (!this.statisticProvider.getStatisticProviderId().startsWith(managedStatisticProvider.statisticProvider.getStatisticProviderId() + "/")) continue;
            if (this.parentManagedStatisticProvider == null) {
                this.parentManagedStatisticProvider = managedStatisticProvider;
                continue;
            }
            if (!managedStatisticProvider.statisticProvider.getStatisticProviderId().startsWith(this.parentManagedStatisticProvider.statisticProvider.getStatisticProviderId() + "/")) continue;
            this.parentManagedStatisticProvider = managedStatisticProvider;
        }
        if (this.parentManagedStatisticProvider != null) {
            this.parentManagedStatisticProvider.childManagedStatisticProviders.add(this);
        }
        for (ManagedStatisticProvider managedStatisticProvider : managedStatisticProviders.values()) {
            if (!managedStatisticProvider.statisticProvider.getStatisticProviderId().startsWith(this.statisticProvider.getStatisticProviderId() + "/")) continue;
            if (managedStatisticProvider.parentManagedStatisticProvider == null) {
                this.childManagedStatisticProviders.add(managedStatisticProvider);
                managedStatisticProvider.parentManagedStatisticProvider = this;
                continue;
            }
            if (managedStatisticProvider.parentManagedStatisticProvider != this.parentManagedStatisticProvider) continue;
            this.parentManagedStatisticProvider.childManagedStatisticProviders.remove(managedStatisticProvider);
            this.childManagedStatisticProviders.add(managedStatisticProvider);
            managedStatisticProvider.parentManagedStatisticProvider = this;
        }
        for (ManagedStatisticFactory managedStatisticFactory : managedStatisticFactories.values()) {
            if (!this.statisticProvider.getStatisticProviderId().matches(managedStatisticFactory.getStatisticFactory().getStatisticProviderFilter())) continue;
            new ManagedStatistic(this, managedStatisticFactory);
        }
        this.managedStatisticProviderMode = DEFAULT_STATISTIC_PROVIDER_MODE;
        this.managedStatisticProviderState = this.getManagedStatisticProviderState();
        this.update();
    }

    public void destroy() {
        boolean oldManagedStatisticProviderState;
        if (this.parentManagedStatisticProvider != null) {
            this.parentManagedStatisticProvider.childManagedStatisticProviders.remove(this);
            for (ManagedStatisticProvider managedStatisticProvider : this.childManagedStatisticProviders) {
                oldManagedStatisticProviderState = managedStatisticProvider.getManagedStatisticProviderState();
                managedStatisticProvider.parentManagedStatisticProvider = this.parentManagedStatisticProvider;
                this.parentManagedStatisticProvider.childManagedStatisticProviders.add(managedStatisticProvider);
                if (managedStatisticProvider.getManagedStatisticProviderState() == oldManagedStatisticProviderState) continue;
                managedStatisticProvider.update();
            }
        } else {
            for (ManagedStatisticProvider managedStatisticProvider : this.childManagedStatisticProviders) {
                oldManagedStatisticProviderState = managedStatisticProvider.getManagedStatisticProviderState();
                managedStatisticProvider.parentManagedStatisticProvider = null;
                if (managedStatisticProvider.getManagedStatisticProviderState() == oldManagedStatisticProviderState) continue;
                managedStatisticProvider.update();
            }
        }
        for (ManagedStatistic managedStatistic : this.managedStatistics) {
            managedStatistic.destroy();
        }
    }

    public void update() {
        this.managedStatisticProviderState = this.getManagedStatisticProviderState();
        for (ManagedStatisticProvider managedStatisticProvider : this.childManagedStatisticProviders) {
            if (managedStatisticProvider.getManagedStatisticProviderMode() != EZBStatisticComponent.STATISTIC_PROVIDER_MODE.INHERIT) continue;
            managedStatisticProvider.update();
        }
        for (ManagedStatistic managedStatistic : this.managedStatistics) {
            if (managedStatistic.getManagedStatisticMode() != EZBStatisticComponent.STATISTIC_MODE.AUTO) continue;
            managedStatistic.update();
        }
    }

    public EZBStatisticProvider getStatisticProvider() {
        return this.statisticProvider;
    }

    public List<ManagedStatistic> getManagedStatistics() {
        return this.managedStatistics;
    }

    public EZBStatisticComponent.STATISTIC_PROVIDER_MODE getManagedStatisticProviderMode() {
        return this.managedStatisticProviderMode;
    }

    public void setManagedStatisticProviderMode(EZBStatisticComponent.STATISTIC_PROVIDER_MODE managedStatisticProviderMode) {
        boolean oldManagedStatisticProviderState = this.getManagedStatisticProviderState();
        this.managedStatisticProviderMode = managedStatisticProviderMode;
        if (this.getManagedStatisticProviderState() != oldManagedStatisticProviderState) {
            this.update();
        }
    }

    public boolean getManagedStatisticProviderState() {
        if (this.getManagedStatisticProviderMode() == EZBStatisticComponent.STATISTIC_PROVIDER_MODE.MANUAL) {
            return this.managedStatisticProviderState;
        }
        if (this.parentManagedStatisticProvider != null) {
            return this.parentManagedStatisticProvider.getManagedStatisticProviderState();
        }
        return true;
    }

    public void setManagedStatisticProviderState(boolean managedStatisticProviderState) {
        boolean oldManagedStatisticProviderState = this.getManagedStatisticProviderState();
        this.managedStatisticProviderState = managedStatisticProviderState;
        if (this.getManagedStatisticProviderMode() == EZBStatisticComponent.STATISTIC_PROVIDER_MODE.INHERIT) {
            this.setManagedStatisticProviderMode(EZBStatisticComponent.STATISTIC_PROVIDER_MODE.MANUAL);
        }
        if (this.getManagedStatisticProviderState() != oldManagedStatisticProviderState) {
            this.update();
        }
    }
}

