/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jca.workmanager;

import java.util.LinkedList;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.ow2.easybeans.jca.workmanager.ResourceWork;
import org.ow2.easybeans.jca.workmanager.ResourceWorkManagerStoppedException;
import org.ow2.easybeans.jca.workmanager.ResourceWorkThread;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ResourceWorkManager
implements WorkManager {
    private static final long MILLISECONDS = 1000L;
    private static Log logger = LogFactory.getLog(ResourceWorkManager.class);
    private LinkedList<ResourceWork> workList = new LinkedList();
    private static int poolnumber = 0;
    private static int threadnumber = 0;
    private int maxpoolsz;
    private int minpoolsz;
    private int poolsz;
    private int freeThreads;
    private long waitingTime;
    private boolean stopped = false;
    private static final long FEW_MORE_SECONDS = 3000L;
    private TransactionManager transactionManager;

    public ResourceWorkManager(TransactionManager transactionManager, int minsz, int maxsz, long threadwait) {
        this.minpoolsz = minsz;
        this.maxpoolsz = maxsz;
        this.waitingTime = threadwait * 1000L;
        this.transactionManager = transactionManager;
        ++poolnumber;
        if (logger.isDebugEnabled()) {
            logger.debug("thread pool {0}", poolnumber);
            logger.debug("minpool size = {0} and maxpool sizez = {1}", minsz, maxsz);
        }
        this.poolsz = 0;
        while (this.poolsz < minsz) {
            ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, poolnumber, threadnumber++);
            resourceWorkThread.setDaemon(true);
            resourceWorkThread.start();
            ++this.poolsz;
        }
    }

    public int getCurrentPoolSize() {
        return this.poolsz;
    }

    public int getMinPoolSize() {
        return this.minpoolsz;
    }

    public int getMaxPoolSize() {
        return this.maxpoolsz;
    }

    public void setMinPoolSize(int minsz) {
        this.minpoolsz = minsz;
    }

    public void setMaxPoolSize(int maxsz) {
        this.maxpoolsz = maxsz;
    }

    public void doWork(Work work) throws WorkRejectedException, WorkCompletedException, WorkException {
        this.doMyWork(work, Long.MAX_VALUE, null, null, 0L);
    }

    public void doWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkCompletedException, WorkException {
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        this.doMyWork(work, timeout, executionContext, workListener, System.currentTimeMillis());
    }

    public long startWork(Work work) throws WorkRejectedException, WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkException {
        ResourceWork resourceWork = new ResourceWork(work, timeout, executionContext, workListener);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        long starttime = System.currentTimeMillis();
        long duration = 0L;
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            this.workList.add(resourceWork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, threadnumber++, poolnumber);
                resourceWorkThread.start();
            } else {
                this.workList.notify();
            }
        }
        boolean started = false;
        Object object = resourceWork;
        synchronized (object) {
            if (!resourceWork.isStarted()) {
                try {
                    long waittime = this.waitingTime;
                    if (timeout < waittime) {
                        waittime = timeout + 3000L;
                    }
                    resourceWork.wait(waittime);
                }
                catch (InterruptedException e) {
                    throw new WorkRejectedException("Interrupted");
                }
            }
            started = resourceWork.isStarted();
        }
        duration = System.currentTimeMillis() - starttime;
        if (!started) {
            object = this.workList;
            synchronized (object) {
                if (!this.workList.remove(resourceWork)) {
                    logger.debug("Cannot remove the work", new Object[0]);
                }
                throw new WorkRejectedException("1");
            }
        }
        return duration;
    }

    public void scheduleWork(Work work) throws WorkRejectedException, WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkException {
        ResourceWork resourceWork = new ResourceWork(work, timeout, executionContext, workListener);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            this.workList.add(resourceWork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, threadnumber++, poolnumber);
                resourceWorkThread.start();
            } else {
                this.workList.notify();
            }
        }
    }

    private void doMyWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener, long creationTime) throws WorkException {
        if (workListener != null) {
            long duration = System.currentTimeMillis() - creationTime;
            if (duration > timeout) {
                logger.warn("REJECTED: duration= {0}", duration);
                workListener.workRejected(new WorkEvent(this, 2, work, null));
                return;
            }
            workListener.workStarted(new WorkEvent(this, 3, work, null));
        }
        Xid xid = null;
        if (executionContext != null && (xid = executionContext.getXid()) != null) {
            long txtimeout = executionContext.getTransactionTimeout();
            try {
                if (txtimeout != -1L) {
                    ((Current)this.transactionManager).begin(xid, txtimeout);
                } else {
                    ((Current)this.transactionManager).begin(xid);
                }
            }
            catch (NotSupportedException e) {
                throw new WorkException("Error starting a new transaction", e);
            }
            catch (SystemException e) {
                throw new WorkException("Error starting a new transaction", e);
            }
        }
        try {
            work.run();
            if (workListener != null) {
                workListener.workCompleted(new WorkEvent(this, 4, work, null));
            }
        }
        catch (Exception e) {
            if (workListener != null) {
                workListener.workCompleted(new WorkEvent(this, 4, work, null));
            }
            throw new WorkCompletedException(e);
        }
        finally {
            if (xid != null) {
                ((Current)this.transactionManager).clearThreadTx();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextWork() throws WorkException, InterruptedException, ResourceWorkManagerStoppedException {
        ResourceWork run = null;
        boolean haswait = false;
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            while (this.workList.isEmpty()) {
                if (haswait && this.freeThreads > this.minpoolsz || this.stopped) {
                    --this.poolsz;
                    throw new ResourceWorkManagerStoppedException("Manager is stopped");
                }
                try {
                    ++this.freeThreads;
                    this.workList.wait(this.waitingTime);
                    --this.freeThreads;
                    haswait = true;
                }
                catch (InterruptedException e) {
                    --this.freeThreads;
                    --this.poolsz;
                    throw e;
                }
            }
            ResourceWork resourceWork = run = this.workList.removeFirst();
            synchronized (resourceWork) {
                logger.debug("Starting a new work", new Object[0]);
                run.setStarted();
                run.notify();
            }
        }
        this.doMyWork(run.getWork(), run.getTimeout(), run.getExecutionContext(), run.getWorkListener(), run.getCreationTime());
    }

    public synchronized void stopThreads() {
        this.stopped = true;
        this.notifyAll();
        --poolnumber;
    }
}

