/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.binder.listener;

import java.lang.reflect.Field;
import java.util.Collection;
import org.osgi.framework.ServiceReference;
import org.ow2.easybeans.osgi.binder.desc.DependencyDescription;
import org.ow2.easybeans.osgi.binder.listener.IDependencyListener;
import org.ow2.easybeans.osgi.binder.util.ReflectionHelper;

public class FieldInjectorListener
implements IDependencyListener {
    private final Object bean;
    private final Field field;
    private final DependencyDescription description;

    public FieldInjectorListener(Object instance, Field field, DependencyDescription description) {
        this.bean = instance;
        this.field = field;
        this.description = description;
    }

    public void added(ServiceReference ref, Object service) {
        if (!ReflectionHelper.isNullableObject(service)) {
            switch (this.description.getMultiplicity()) {
                case MULTIPLE: {
                    Collection collection = ReflectionHelper.getFieldValue(this.bean, this.field, Collection.class);
                    collection.add(service);
                    break;
                }
                case SINGLE: {
                    ReflectionHelper.setFieldValue(this.bean, this.field, service);
                }
            }
        }
    }

    public void changed(ServiceReference ref, Object service) {
    }

    public void removed(ServiceReference ref, Object service) {
        if (!ReflectionHelper.isNullableObject(service)) {
            switch (this.description.getMultiplicity()) {
                case MULTIPLE: {
                    Collection collection = ReflectionHelper.getFieldValue(this.bean, this.field, Collection.class);
                    collection.remove(service);
                    break;
                }
                case SINGLE: {
                    ReflectionHelper.setFieldValue(this.bean, this.field, null);
                }
            }
        }
    }
}

