/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.ow2.jonas.deployablemonitor.DeployableMonitor;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DeployableMonitorService
extends AbsServiceImpl
implements MonitoringService {
    public static final String DEVELOPMENT_MODE_PROPERTY = "development";
    public static final String DIRECTORIES_LIST_PROPERTY = "directories";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    public static final String DEFAULT_DIRECTORY = JONAS_BASE + File.separator + "deploy";
    private Log logger = LogFactory.getLog(DeployableMonitor.class);
    private boolean developmentMode = true;
    private JmxService jmxService = null;
    private List<File> directories = new LinkedList<File>();
    private DeployableMonitor deployableMonitor = new DeployableMonitor(this);
    private J2EEServerService j2eeServer = null;
    private int monitorInterval;

    protected void doStart() throws ServiceException {
        this.logger.info("Use the deploy directories ''{0}'', development mode is ''{1}''", this.directories, this.developmentMode);
        File defaultDirectory = new File(DEFAULT_DIRECTORY);
        if (!defaultDirectory.exists()) {
            this.logger.info("Creating default deploy directory ''{0}''", defaultDirectory);
            defaultDirectory.mkdirs();
        }
        this.directories.add(defaultDirectory);
        this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.deployableMonitorService(this.getDomainName()));
        }
        catch (Exception e) {
            this.logger.warn("Cannot register MBean for Deployable Monitor service", e);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startMonitoring() {
        if (!this.getDeployableMonitor().isAlive()) {
            this.logger.debug("Start DeployableMonitor", new Object[0]);
            this.deployableMonitor.start();
        }
    }

    protected void doStop() throws ServiceException {
        if (this.jmxService != null) {
            try {
                this.jmxService.unregisterModelMBean(JonasObjectName.deployableMonitorService(this.getDomainName()));
            }
            catch (Exception e) {
                this.logger.warn("Cannot unregister MBean for Deployable Monitor service", e);
            }
        }
        this.deployableMonitor.stopOrder();
        this.deployableMonitor = null;
        this.logger.info("DeployableMonitor stopped successfully", new Object[0]);
    }

    public void setDirectories(String dirs) {
        List<String> additionalDirectories = DeployableMonitorService.convertToList(dirs);
        for (String dir : additionalDirectories) {
            File tmpFile = new File(dir);
            if (!tmpFile.isAbsolute()) {
                tmpFile = new File(JONAS_BASE + File.separator + dir);
            }
            if (!tmpFile.exists()) {
                this.logger.warn("The given directory ''{0}'' is neither present on the filesystem or in JONAS_BASE ''{1}''", tmpFile, JONAS_BASE);
                continue;
            }
            this.directories.add(tmpFile);
        }
        this.getDeployableMonitor().setDirectories(this.directories);
    }

    public String[] getDirectoryNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (File directory : this.directories) {
            result.add(directory.getName());
        }
        String[] dirNames = new String[result.size()];
        int i = 0;
        for (String dir : result) {
            dirNames[i++] = dir;
        }
        return dirNames;
    }

    public void setExclusions(String exclusionList) {
        List<String> exclusions = DeployableMonitorService.convertToList(exclusionList);
        this.getDeployableMonitor().setExclusionPatterns(exclusions);
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.getDeployableMonitor().setDeployerManager(deployerManager);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }

    public void firstCheckEnded() {
        this.j2eeServer.setRunning();
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(String mode) {
        this.developmentMode = mode.equals("inherit") ? this.getServerProperties().isDevelopment() : Boolean.parseBoolean(mode);
        this.getDeployableMonitor().setDevelopmentMode(this.developmentMode);
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
        this.getDeployableMonitor().setMonitorInterval(monitorInterval);
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    private DeployableMonitor getDeployableMonitor() {
        if (this.deployableMonitor == null) {
            this.deployableMonitor = new DeployableMonitor(this);
        }
        return this.deployableMonitor;
    }
}

