/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.XMLSerializer;
import org.w3c.dom.Document;

public abstract class ArchiveStorer {
    public static final int MAX_BUFFER_SIZE = 1024;
    private static I18n i18n = I18n.getInstance(ArchiveStorer.class);
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.genbase");
    private J2EEArchive archive;
    private List already;
    private String out = "";

    public ArchiveStorer(J2EEArchive archive) {
        this.archive = archive;
        this.already = new Vector();
        this.already.add(this.convertName("META-INF/MANIFEST.MF"));
    }

    protected static void fill(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = is.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, read);
        }
        os.flush();
    }

    protected abstract void addFile(String var1) throws IOException;

    protected abstract String convertName(String var1);

    protected abstract OutputStream getOutputStream(String var1) throws IOException;

    public void store() throws GenBaseException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Writing '" + this.out + "' ..."));
        }
        for (String name : this.archive.getContainedFiles()) {
            try {
                if (this.archive.omit(this.convertName(name)) || this.already.contains(this.convertName(name))) continue;
                this.addFile(name);
                this.already.add(this.convertName(name));
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("ArchiveStorer.store.addFile", name);
                throw new GenBaseException(err, ioe);
            }
        }
        Map descs = this.archive.getDescriptors();
        for (String name : descs.keySet()) {
            try {
                XMLSerializer ser = new XMLSerializer((Document)descs.get(name));
                OutputStream os = this.getOutputStream(name);
                ser.serialize(os);
                os.flush();
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("ArchiveStorer.store.serialize", name);
                throw new GenBaseException(err, ioe);
            }
        }
    }

    public static I18n getI18n() {
        return i18n;
    }

    public J2EEArchive getArchive() {
        return this.archive;
    }

    public void setOut(String out) {
        this.out = out;
    }
}

