/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.service.ServiceException;

public class GenicServiceWrapper {
    private static final String GENIC_CLASSNAME = "org.ow2.jonas.generators.genic.GenIC";

    private GenicServiceWrapper() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void callGenic(String[] args) throws ServiceException {
        LoaderManager lm = LoaderManager.getInstance();
        ClassLoader old = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            if (ext == null) {
                throw new ServiceException("cannot get tools classloader");
            }
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            Class<?> manager = ext.loadClass(GENIC_CLASSNAME);
            Method m = manager.getDeclaredMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
            if (old == null) return;
            Thread.currentThread().setContextClassLoader(old);
            return;
        }
        catch (InvocationTargetException e) {
            try {
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                if (!(e.getTargetException() instanceof ServiceException)) throw new ServiceException("Problems when invoking main method from GenIC", e.getTargetException());
                throw (ServiceException)e.getTargetException();
                catch (Exception e2) {
                    throw new ServiceException("Problems when invoking main method from GenIC", e2);
                }
            }
            catch (Throwable throwable) {
                if (old == null) throw throwable;
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
        }
    }
}

